package com.mmc.oms.controller;

import com.mmc.oms.common.ResultBody;
import com.mmc.oms.common.Send;
import com.mmc.oms.common.Take;
import com.mmc.oms.model.dto.OrderInfoDTO;
import com.mmc.oms.model.qo.OrderInfoQO;
import com.mmc.oms.model.vo.LeaseOrderVO;
import com.mmc.oms.model.vo.OrderStatusVO;
import com.mmc.oms.model.vo.OrderVcuVO;
import com.mmc.oms.model.vo.ReturnWareVO;
import com.mmc.oms.service.RentalOrdersService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author small @Date 2023/5/26 10:49 @Version 1.0
 */
@RestController
@RequestMapping("/RentalOrders")
@Api(tags = {"web租赁订单"})
public class RentalOrdersController extends BaseController {

    @Autowired
    private RentalOrdersService rentalOrdersService;

    @ApiOperation(value = "租赁-下单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = OrderInfoDTO.class)})
    @PostMapping("feignAddLease")
    public OrderInfoDTO feignAddLease(HttpServletRequest request, @RequestBody LeaseOrderVO param) {
        return rentalOrdersService.feignAddLease(this.getCurrentAccount(request), param);
    }

    @ApiOperation(value = "web 租赁订单-分页-列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = OrderInfoDTO.class)})
    @PostMapping("listOfRentalOrders")
    public ResultBody listOfRentalOrders(HttpServletRequest request, @RequestBody OrderStatusVO orderStatusVO) {
        return ResultBody.success(
                rentalOrdersService.listOfRentalOrders(orderStatusVO, this.getCurrentAccount(request)));
    }


    @ApiOperation(value = "后台管理 租赁订单-分页-列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = OrderInfoDTO.class)})
    @PostMapping("listPcWechatOrder")
    public ResultBody listPcWechatOrder(HttpServletRequest request, @RequestBody OrderInfoQO param) {
        return ResultBody.success(
                rentalOrdersService.listPcOrderInfo(param, this.getCurrentAccount(request)));
    }


    @ApiOperation(value = "订单-详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = OrderInfoDTO.class)})
    @GetMapping("orderDetail")
    public ResultBody<OrderInfoDTO> orderDetail(
            @ApiParam(value = "订单编号") @RequestParam(required = true) String orderNo) {
        return ResultBody.success(rentalOrdersService.getOrderDetail(orderNo));
    }


    @ApiOperation(value = "小程序-云仓-订单-分页-列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = OrderInfoDTO.class)})
    @PostMapping("listPageWechatOrder")
    public ResultBody listPageWechatOrder(
            HttpServletRequest request, @RequestBody OrderInfoQO param) {
        return ResultBody.success(rentalOrdersService.listPageWechatOrder(this.getCurrentAccount(request), param));
    }


    @ApiOperation(value = "订单状态的变更")
    @GetMapping("orderStatusChanges")
    public ResultBody orderStatusChanges(@RequestParam(value = "orderNo", required = true) String orderNo,
                                         @RequestParam(value = "tranStatus", required = true) Integer tranStatus) {
        return ResultBody.success(rentalOrdersService.orderStatusChanges(orderNo, tranStatus));
    }


    @ApiOperation(value = "v1.0.1后台管理——发货-订单/ 卖家发货")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("sendOrderWare")
    public ResultBody sendOrderWare(HttpServletRequest request,
                                    @Validated({Send.class}) @RequestBody OrderVcuVO param) {
        return rentalOrdersService.sendOrderWare(this.getCurrentAccount(request), param);
    }


    @ApiOperation(value = "web 确认收货-订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("renterTakeOrder")
    public ResultBody renterTakeOrder(@Validated({Take.class}) @RequestBody OrderVcuVO param) {
        return rentalOrdersService.renterTakeOrder(param);
    }


    @ApiOperation(value = "web 商品归还-订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("returnOrderWare")
    public ResultBody returnOrderWare(@RequestBody ReturnWareVO param) {
        return rentalOrdersService.returnOrderWare(param);
    }


    @ApiOperation(value = "后台管理——平台确认归还")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("pfConfirmOrderWare")
    public ResultBody pfConfirmOrderWare(HttpServletRequest request, @RequestBody OrderVcuVO param) {
        return rentalOrdersService.pfConfirmOrderWare(this.getCurrentAccount(request), param);
    }
    

}
