package com.mmc.oms.controller;

import com.mmc.oms.common.*;
import com.mmc.oms.model.dto.CouponActivityDTO;
import com.mmc.oms.model.dto.CouponDTO;
import com.mmc.oms.model.dto.CouponUserDTO;
import com.mmc.oms.model.dto.CouponViewDTO;
import com.mmc.oms.model.qo.CouponInfoQO;
import com.mmc.oms.model.qo.CouponUserInfoQO;
import com.mmc.oms.model.qo.ProductCouponQO;
import com.mmc.oms.model.vo.CouponInfoActivityVO;
import com.mmc.oms.model.vo.CouponInfoVO;
import com.mmc.oms.service.CouponBackService;
import io.swagger.annotations.*;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * @Author small
 * @Date 2023/5/24 13:28
 * @Version 1.0
 */
@RestController
@RequestMapping("/coupon/back")
@Api(tags = {"优惠券管理后台-相关接口"})
public class CouponBackController {

    @Resource
    private CouponBackService couponBackService;


    @ApiOperation(value = "V1.0.1--新增优惠券")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = CouponDTO.class)})
    @PostMapping("/save")
    public ResultBody<CouponDTO> saveCouponInfo(@RequestParam(value = "file",required = false) MultipartFile file
            , @RequestBody CouponInfoVO couponInfoVO){
        return couponBackService.saveCouponBackInfo(couponInfoVO,file);
    }

    @ApiOperation(value = "V1.0.1--新增裂变优惠券")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK")})
    @PostMapping("/saveActivity")
    public ResultBody saveActivityCouponInfo(@Validated(Insert.class) @RequestBody CouponInfoActivityVO couponInfoActivityVO){
        return couponBackService.saveActivityCouponInfo(couponInfoActivityVO);
    }


    @ApiOperation(value = "V1.0.1--优惠券列表-分页")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CouponDTO.class)})
    @PostMapping("/pageList")
    public ResultBody<PageResult<CouponDTO>> pageCouponList(@Validated(Page.class) @RequestBody CouponInfoQO couponInfoQO) {
        return couponBackService.pageCouponList(couponInfoQO);
    }


    @ApiOperation(value = "V1.0.1--裂变优惠券列表-分页")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CouponActivityDTO.class)})
    @PostMapping("/pageActivityList")
    public ResultBody<PageResult<CouponActivityDTO>> pageActivityCouponList(@Validated(Page.class) @RequestBody CouponInfoQO couponInfoQO) {
        return couponBackService.pageActivityCouponList(couponInfoQO);
    }

    @ApiOperation(value = "优惠券-下拉")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CouponActivityDTO.class)})
    @GetMapping("/getActivityCouponPullDown")
    public ResultBody<CouponActivityDTO> getActivityCouponPullDown(@ApiParam(value = "活动类型: 1裂变活动 2普通活动", required = true)
                                                @RequestParam(required = true, value = "type") Integer type) {
        return couponBackService.getActivityCouponPullDown(type);
    }

    @ApiOperation(value = "V1.0.1--增发优惠券")
    @ApiResponses({@ApiResponse(code = 200, message = "OK")})
    @PostMapping("/increase")
    public ResultBody increaseCoupon(@Validated(Update.class)
                                     @ApiParam(value = "id", required = true)
                                     @RequestParam(required = true, value = "id") Integer id,
                                     @ApiParam(value = "数量", required = true)
                                     @RequestParam(required = true, value = "count") Integer count){
        return couponBackService.increaseCouponCount(id, count);
    }

    @ApiOperation(value = "V1.0.1--关闭优惠券发放")
    @ApiResponses({@ApiResponse(code = 200, message = "OK")})
    @PostMapping("/shutDown")
    public ResultBody shutDown(@Validated(Update.class)
                               @ApiParam(value = "id", required = true)
                               @RequestParam(required = true, value = "id") Integer id){
        return couponBackService.shutDown(id);
    }


    @ApiOperation(value = "V1.0.1--获取优惠券使用数据")
    @ApiResponses({@ApiResponse(code = 200, message = "OK",response = CouponViewDTO.class)})
    @GetMapping("/getData")
    public ResultBody<CouponViewDTO> getViewData(@Validated(Query.class)
                                  @ApiParam(value = "id", required = true)
                                  @RequestParam(required = true, value = "id") Integer id){
        return couponBackService.couponViewData(id);
    }

    @ApiOperation(value = "V1.0.1--获取优惠券明细列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CouponUserDTO.class)})
    @PostMapping("/getUserCouponList")
    public ResultBody<CouponUserDTO> getCouponUserList(@Validated(Page.class) @RequestBody CouponUserInfoQO couponUserInfoQO){
        return couponBackService.getCouponUserList(couponUserInfoQO);
    }

    @ApiOperation(value = "V1.0.1--优惠券明细列表-导出")
    @ApiResponses({@ApiResponse(code = 200, message = "OK")})
    @PostMapping("/downloadCouponUserList")
    public void downloadCouponUserList(@Validated(value = {Others.class}) @RequestBody CouponUserInfoQO couponUserInfoQO,
                                       HttpServletResponse response){
        try {
            couponBackService.downloadCouponUserList(response,couponUserInfoQO);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @ApiOperation(value = "feign-获取优惠券详情",hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CouponDTO.class)})
    @GetMapping("/feignByIds")
    public List<CouponDTO> feignByIds(@RequestParam List<Integer> ids){
        return couponBackService.feignByIds(ids);
    }

    @ApiOperation(value = "feign-获取裂变优惠券详情",hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CouponActivityDTO.class)})
    @GetMapping("/feignGetActivity")
    public CouponActivityDTO feignGetCouponActivityById(@RequestParam Integer id) {
        return couponBackService.getCouponActivityById(id);
    }

    @ApiOperation(value = "feign-获取裂变优惠券详情-批量",hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CouponActivityDTO.class)})
    @PostMapping("/feignGetActivityList")
    public List<CouponActivityDTO> feignGetCouponActivityByList(@RequestBody List<Integer> id) {
        return couponBackService.getCouponActivityList(id);
    }

    @ApiOperation(value = "feign-优惠券定时修改状态",hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK")})
    @GetMapping("/feignExpireCoupon")
    public void feignExpireCoupon() {
        couponBackService.overdueCouponTask();
    }

    @ApiOperation(value = "feign-根据用户标签获取对应优惠券",hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CouponDTO.class)})
    @GetMapping("/feignGetCouponType")
    public List<CouponDTO>  feignGetCouponType(@RequestParam Integer type) {
        return couponBackService.feignGetCouponType(type);
    }

    @ApiOperation(value = "V2.3.2——商品优惠券普通活动列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CouponDTO.class)})
    @PostMapping("/ordinaryActivities")
    public ResultBody<PageResult<CouponDTO>>  ordinaryActivities(@Validated(Page.class) @RequestBody ProductCouponQO productCouponQO) {
        return couponBackService.ordinaryActivities(productCouponQO);
    }
    @ApiOperation(value = "V2.3.2——商品优惠券裂变活动列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CouponDTO.class)})
    @PostMapping("/fissionActivity")
    public ResultBody<PageResult<PageResult>>  fissionActivity(@Validated(Page.class) @RequestBody ProductCouponQO productCouponQO) {
        return couponBackService.fissionActivity(productCouponQO);
    }
}
