package com.mmc.oms.common;

import com.alibaba.fastjson.JSONArray;
import com.mmc.oms.jwt.JwtConstant;

import com.mmc.oms.model.dto.BaseAccountDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * @Author small
 * @Date 2023/5/24 15:59
 * @Version 1.0
 */
@Component
public class AuthHandler {

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    /**
     * 获取当前用户
     *
     * @param request
     * @return
     */
//	public CurrentUserDTO getCurrentUser(HttpServletRequest request) {
//		// 登录未做好-统一通过此方法获取当前用户信息
//		Integer id = Integer.parseInt(request.getHeader(JwtConstant.USERIDKEY).toString());
//		Integer roleId = Integer.parseInt(request.getHeader(JwtConstant.ROLEIDKEY).toString());
//		return CurrentUserDTO.builder().id(id).roleId(roleId).build();
//	}

    /**
     * 获取当前登录账号信息
     */
    public BaseAccountDTO getCurrentAccount(String token) {
        // 获取登录的基本信息
        String json = stringRedisTemplate.opsForValue().get(token);
        if (StringUtils.isEmpty(json)) {
            throw new BizException(ResultEnum.LOGIN_ACCOUNT_STATUS_ERROR);
        }
        BaseAccountDTO account = JsonUtil.parseJsonToObj(json, BaseAccountDTO.class);

        // 如果是PC管理端-获取部门缓存信息
       /* if (JwtConstant.SXTB_ACCOUNT_TOKEN.equals(account.getTokenPort())) {
            account.getCompanyInfo().setCompanys(this.getCompanys(account.getCompanyInfo().getId()));
        }*/
        return account;
    }


    /**
     * 更新单位缓存
     *
     * @param companys
     * @param companyId
     */
    public void refreshCompanys(List<Integer> companys, Integer companyId) {
        String key = RedisConstant.getCompanyChildKey(companyId);
        stringRedisTemplate.opsForValue().set(
                key, JsonUtil.parseObjToJson(companys),
                JwtConstant.EXPIRATION, TimeUnit.MILLISECONDS);
    }

    public List<Integer> getCompanys(Integer companyId) {
        String key = RedisConstant.getCompanyChildKey(companyId);
        if (stringRedisTemplate.hasKey(key)) {
            String json = stringRedisTemplate.opsForValue().get(key);
            if(!StringUtils.isEmpty(json)) {
                List<Integer> list = JSONArray.parseArray(json, Integer.class);
                return list;
            }
        }
        return new ArrayList<Integer>();
    }

    public void updateLoginCache(String token, BaseAccountDTO loginInfo) {
        stringRedisTemplate.opsForValue().set(token, JsonUtil.parseObjToJson(loginInfo), JwtConstant.EXPIRATION,
                TimeUnit.MILLISECONDS);
    }

    /**
     * 检验缓存token是否存在
     *
     * @param token
     * @return
     */
    public boolean hasToken(String token) {
        return stringRedisTemplate.hasKey(token);
    }

    /**
     * 检验token是否进了失效名单 && 检验token是否为最新token
     *
     * @param token
     * @return
     */
    public boolean isDisableToken(String token) {
        List<String> disableTokens = stringRedisTemplate.opsForList().range(RedisConstant.DISABLE_TOKEN_LIST, 0, -1);// 需要强制失效的token
        return (!CollectionUtils.isEmpty(disableTokens) && disableTokens.contains(token));
    }

    /**
     * 检测是否为最新的token
     *
     * @param userId
     * @param roleId
     * @param tokenType
     */
    public boolean isLatestToken(String userId, String roleId, String tokenType, String token) {
        String key = RedisConstant.createLoginTokenKey(tokenType, roleId, userId);
        return (token.equals(stringRedisTemplate.opsForValue().get(key)));
    }

    public String getUserToken(Integer userAccountId, Integer roleId, String tokenType) {
        String token = stringRedisTemplate.opsForValue()
                .get(RedisConstant.createLoginTokenKey(tokenType, roleId.toString(), userAccountId.toString()));// 查询他的token
        return token;
    }

    public void disableOneToken(Integer userAccountId, Integer roleId, String tokenType) {
        String token = this.getUserToken(userAccountId, roleId, tokenType);// 查询他的token
        if (!StringUtils.isEmpty(token)) {
            stringRedisTemplate.opsForList().leftPush(RedisConstant.DISABLE_TOKEN_LIST, token);// 加入token失效列表
        }
        String cacheLoginKey = RedisConstant.createLoginCacheKey(tokenType, userAccountId);
        stringRedisTemplate.delete(cacheLoginKey);// 删除登录信息

    }

    public void disableListToken(List<Integer> userAccountIds, Integer roleId, String tokenType) {
        Set<String> tokenKeyList = stringRedisTemplate
                .keys(RedisConstant.tokenPreFix(tokenType, roleId.toString()) + "*");// 模糊查询所有key
        if (!CollectionUtils.isEmpty(tokenKeyList)) {
            List<String> tokenList = stringRedisTemplate.opsForValue().multiGet(tokenKeyList);
            stringRedisTemplate.opsForList().leftPushAll(RedisConstant.DISABLE_TOKEN_LIST, tokenList);
        }

        userAccountIds.forEach(id -> {
            String cacheLoginKey = RedisConstant.createLoginCacheKey(tokenType, id);
            stringRedisTemplate.delete(cacheLoginKey);
        });
    }

}
