package com.mmc.oms.enums;

/**
 * @author: zj
 * @Date: 2023/9/4 14:36
 */
public enum LeaseOrderStatus {
    PLACED_AN_ORDER(100, "已下单", "待付款"),
    PAID(200, "已付款", "等发货"),
    SHIPPED(300, "卖家已发货", "待买家收货"),
    TO_BE_RETURNED(400, "待归还", "待归还"),
    WAITING_MERCHANT_CONFIRM(500, "等待商家确认", "等待商家确认"),
    COMPLETE_TRANSACTION(600, "交易完成", "交易完成"),
    APPLY_REFUND(700, "申请退款", "退款中"),
    CLOSE(999, "订单关闭", "订单关闭");

    public Integer getCode() {
        return code;
    }

    public String getDoing() {
        return doing;
    }

    public String getWaiting() {
        return waiting;
    }

    LeaseOrderStatus(Integer code, String doing, String waiting) {
        this.code = code;
        this.doing = doing;
        this.waiting = waiting;
    }

    private Integer code;
    private String doing;
    private String waiting;
}
