package com.mmc.oms.controller.lease;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.BaseController;
import com.mmc.oms.model.dto.lease.LeaseOrderDTO;
import com.mmc.oms.model.qo.uav.UavOrderQO;
import com.mmc.oms.model.vo.lease.AddLeaseOrderVO;
import com.mmc.oms.model.vo.lease.LeaseOrderRefundVO;
import com.mmc.oms.service.lease.LeaseOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * @author: lw
 * @Date: 2023/9/21 16:29
 */
@Api(tags = {"最新版--租赁订单接口"})
@RestController
@RequestMapping("/lease/order/")
public class LeaseOrderController extends BaseController {

    @Resource
    private LeaseOrderService leaseOrderService;

    @ApiOperation(value = "提交订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LeaseOrderDTO.class)})
    @PostMapping("addLeaseOrder")
    public ResultBody<LeaseOrderDTO> addLeaseOrder(@RequestBody AddLeaseOrderVO param, HttpServletRequest request) {
        return leaseOrderService.addLeaseOrder(param, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "订单详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LeaseOrderDTO.class)})
    @GetMapping("detail")
    public ResultBody<LeaseOrderDTO> detail(@RequestParam Integer id, HttpServletRequest request) throws Exception {
        return leaseOrderService.detail(id, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "买家申请退款（取消订单）")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("close")
    public ResultBody close(@RequestBody LeaseOrderRefundVO leaseOrderRefundVO, HttpServletRequest request) {
        return leaseOrderService.close(leaseOrderRefundVO, this.getCurrentAccount(request).getToken());
    }

    @ApiOperation(value = "后台订单列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LeaseOrderDTO.class)})
    @PostMapping("list")
    public ResultBody<LeaseOrderDTO> list(@RequestBody UavOrderQO uavOrderQO, HttpServletRequest request) {
        return leaseOrderService.list(uavOrderQO, this.getCurrentAccount(request));
    }
}
