package com.mmc.oms.model.dto.uav;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/9/4 14:59
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "订单sku信息")
public class UavOrderSkuDTO implements Serializable {
    private static final long serialVersionUID = -7021228030949249793L;
    @ApiModelProperty("订单规格id")
    private Integer id;
    @ApiModelProperty("订单id")
    private Integer uavOrderId;
    @ApiModelProperty("采购订单id")
    private Integer uavPurchaseOrderId;
    @ApiModelProperty("商品id")
    private Integer mallGoodsId;
    @ApiModelProperty("商品名称")
    private String tradeName;
    @ApiModelProperty("商品规格id")
    private Integer priceStockId;
    @ApiModelProperty("商品规格")
    private String productSpec;
    @ApiModelProperty("购买数量")
    private Integer orderNum;
    @ApiModelProperty("单价")
    private BigDecimal unitPrice;
    @ApiModelProperty("商品规格图片")
    private String skuImage;
    @ApiModelProperty("商品规格编号")
    private String skuNo;
    @ApiModelProperty("下单时间")
    private Date createTime;
}
