package com.mmc.oms.service.mall.impl;

import com.mmc.oms.dao.mall.OrderGoodsProdDao;
import com.mmc.oms.entity.mall.MallOrderSimpleDO;
import com.mmc.oms.entity.mall.OrderGoodsProdDetailBO;
import com.mmc.oms.entity.mall.OrderGoodsProdDetailDO;
import com.mmc.oms.service.mall.OrderGoodsProdService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author dahang
 * @since 2022-10-29
 */
@Service
public class OrderGoodsProdServiceImpl implements OrderGoodsProdService {

    @Resource
    private OrderGoodsProdDao orderGoodsProdDao;

    @Override
    public List<OrderGoodsProdDetailBO> getProductInfoByMallId(Long orderId) {
        return orderGoodsProdDao.getProductInfoByMallId(orderId);
    }

    @Override
    public List<MallOrderSimpleDO> listOrderGoodsProdBaseInfo(List<Long> mallOrderIds) {
        List<MallOrderSimpleDO> orderSimpleDOS = orderGoodsProdDao.listOrderGoodsProdBaseInfo(mallOrderIds);
        return orderSimpleDOS;
    }

    @Override
    public List<OrderGoodsProdDetailDO> listPMallOrderProdList(Long orderId) {
        List<OrderGoodsProdDetailDO> orderGoodsProdDetailDOList = orderGoodsProdDao.listPMallOrderProdList(orderId);
        return orderGoodsProdDetailDOList;
    }
}
