package com.mmc.oms.service.mall.impl;


import com.mmc.oms.dao.mall.OrderGoodsIndstDao;
import com.mmc.oms.entity.mall.MallOrderSimpleDO;
import com.mmc.oms.entity.mall.OrderGoodsIndstProdListBO;
import com.mmc.oms.entity.mall.OrderGoodsIndstProdListDO;
import com.mmc.oms.service.mall.OrderGoodsIndstService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author dahang
 * @since 2022-10-29
 */
@Service
public class OrderGoodsIndstServiceImpl implements OrderGoodsIndstService {

    @Resource
    private OrderGoodsIndstDao orderGoodsIndstDao;

    @Override
    public List<OrderGoodsIndstProdListBO> getProductInfoByMallId(Long orderId) {
        return orderGoodsIndstDao.getProductInfoByMallId(orderId);
    }

    @Override
    public List<MallOrderSimpleDO> listOrderGoodsIndstBaseInfo(List<Long> mallOrderIds) {
        List<MallOrderSimpleDO> mallOrderSimpleDOList = orderGoodsIndstDao.listOrderGoodsIndstBaseInfo(mallOrderIds);
        return mallOrderSimpleDOList;
    }

    @Override
    public List<OrderGoodsIndstProdListDO> listIMallOrderProdList(Long orderId) {
        List<OrderGoodsIndstProdListDO> orderGoodsIndstProdListDOS = orderGoodsIndstDao.listIMallOrderProdList(orderId);
        return orderGoodsIndstProdListDOS;
    }
}
