package com.mmc.oms.model.vo.mall;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/6/2 20:55
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MallOrderExpressVO implements Serializable {
    private static final long serialVersionUID = 4364047174162933119L;
    @ApiModelProperty(value = "orderId")
    @NotNull
    private Long orderId;
    @ApiModelProperty(value = "物流公司代号")
    @NotNull
    private String sendExpCode;
    @ApiModelProperty(value = "发货-物流单号")
    @NotNull
    private String sendExpNo;
    @ApiModelProperty(value = "收货人姓名")
    @NotNull
    private String takeName;
    @ApiModelProperty(value = "收货人电话")
    @NotNull
    private String takePhone;
    @ApiModelProperty(value = "收货地区")
    @NotNull
    private String takeRegion;
    @ApiModelProperty(value = "收货详细地址")
    @NotNull
    private String takeAddress;
    @ApiModelProperty(value = "签收时间")
    private Date receiveTime;
    @ApiModelProperty(value = "是否签收")
    private Integer receive;
}
