package com.mmc.oms.model.dto.mall;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class UavContractInfoDTO implements Serializable {
    private static final long serialVersionUID = 8595958456591915448L;
    private Integer id;
    private Integer userAccountId;
    private Long mallOrderId;
    private String contractTitle;
    @ApiModelProperty(value = "状态:（0:等待用户签署、1：用户签署失败、2：等待甲方签署(用户签署成功) 3：用户签署失败、4：甲方签署成功、5：已完成")
    private Integer signStatus;
    @ApiModelProperty(value = "签署完成日期")
    private Date singerTime;
    private String contractNo;
    private Date createTime;
    private Date updateTime;
    private Integer deleted;
    @ApiModelProperty(value = "买家签署失败备注信息")
    private String aRemark;
    @ApiModelProperty(value = "科比特签署失败备注信息")
    private String bRemark;
    @ApiModelProperty(value = "买家签署交易号")
    private String aTransactionId;
    @ApiModelProperty(value = "科比特签署交易号")
    private String bTransactionId;
    @ApiModelProperty(value = "归档日期")
    private Date archiveDate;
}
