package com.mmc.oms.feign.hystrix;

import com.mmc.oms.feign.UserAppApi;
import com.mmc.oms.model.dto.mall.CooperationTagDTO;
import com.mmc.oms.model.dto.user.UserAccountSimpleDTO;
import com.mmc.oms.model.qo.mall.BUserAccountQO;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/18 17:08
 */
@Slf4j
public class UserAppApiHystrix implements UserAppApi {
    @Override
    public UserAccountSimpleDTO feignGetUserSimpleInfo(Integer userAccountId, String token) {
        log.error("熔断：feignGetUserSimpleInfo：{}", userAccountId);
        return null;
    }

    @Override
    public List<Integer> feignListUserAccountIds(Integer provinceCode, Integer cityCode, Integer districtCode, String token) {
        log.error("熔断：feignListUserAccountIds：{}， {}， {}", provinceCode, cityCode, districtCode);
        return null;
    }

    @Override
    public List<UserAccountSimpleDTO> feignListBAccountPage(BUserAccountQO bUserAccountQO, String token) {
        log.error("熔断：feignListBAccountPage：{}", bUserAccountQO);
        return null;
    }

    @Override
    public List<UserAccountSimpleDTO> feignListUserAccountByIds(List<Integer> ids, String token) {
        log.error("熔断：feignListUserAccountByIds：{}", ids);
        return null;
    }

    @Override
    public List<UserAccountSimpleDTO> feignListRcdUserInfo(List<Integer> userIds) {
        log.error("熔断：feignListRcdUserInfo：{}", userIds);
        return null;
    }

    @Override
    public Integer feignGetSuperiorRef(Integer userAccountId) {
        log.error("熔断：feignGetSuperiorRef：{}", userAccountId);
        return null;
    }

    @Override
    public UserAccountSimpleDTO feignGetUserRcdInfo(Integer userAccountId) {
        log.error("熔断：feignGetUserRcdInfo：{}", userAccountId);
        return null;
    }

    @Override
    public List<CooperationTagDTO> feignListCooperationTag() {
        log.error("熔断：feignListCooperationTag：{}");
        return null;
    }
}
