package com.mmc.oms.entity.mall;

import com.mmc.oms.model.dto.mall.OrderPayDTO;
import com.mmc.oms.model.vo.mall.OrderPayVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;

/**
 * @author 作者 geDuo
 * @version 创建时间：2022年3月22日 下午1:33:55
 * @explain 类说明
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OrderPayDO implements Serializable {
	private static final long serialVersionUID = -2577204623479240233L;
	private Integer id;
	private Long orderId;
	private Integer userAccountId;
	private Integer payType;
	private Integer payStatus;
	private String vouchr;
	private String payRemark;
	private String refuseReason;
	private Date updateTime;
	private Date createTime;

	public OrderPayDO(OrderPayVO param, Integer userAccountId) {
		this.orderId = param.getOrderId();
		this.vouchr = String.join(",", param.getVouchr());
		this.payRemark = param.getPayRemark();
		this.userAccountId = userAccountId;
	}

	public OrderPayDTO buildOrderPayDTO() {
		return OrderPayDTO.builder().orderId(orderId).vouchr(Arrays.asList(this.vouchr.split(","))).payRemark(payRemark)
				.payType(payType).refuseReason(refuseReason).build();
	}
}
