package com.mmc.oms.entity.mall;

import com.mmc.oms.model.dto.mall.MallOrderDTO;
import com.mmc.oms.model.dto.mall.MallOrderFinishDTO;
import com.mmc.oms.model.dto.mall.MallOrderPageDTO;
import com.mmc.oms.model.dto.mall.UserAddressDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/6/2 20:50
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("商城订单")
public class MallOrderDO implements Serializable {
	private static final long serialVersionUID = 1L;

	@ApiModelProperty("id")
	private Long id;

	@ApiModelProperty("pid")
	private Integer pid;

	@ApiModelProperty("订单编号")
	private String orderNo;

	@ApiModelProperty("状态码")
	private Integer statusCode;

	@ApiModelProperty("user_account_id")
	private Integer userAccountId;

	@ApiModelProperty("买家uid")
	private String uid;

	@ApiModelProperty("买家姓名")
	private String userName;

	@ApiModelProperty("买家手机号")
	private String phoneNum;

	@ApiModelProperty("0全款购买 1分期付款")
	private Integer payMethod;

	@ApiModelProperty("订单关闭原因")
	private String shutReason;

	@ApiModelProperty("update_time")
	private Date updateTime;

	@ApiModelProperty("create_time")
	private Date createTime;

	@ApiModelProperty("推荐人id")
	private Integer recMallUserId;
	@ApiModelProperty("推荐人")
	private String recMallUserName;

	@ApiModelProperty("推荐人订单金额")
	private BigDecimal rcdOrderAmount;

	@ApiModelProperty("用户收货地址id")
	private Integer userAddressId;

	@ApiModelProperty("订单交期")
	private Date deliveryTime;

	@ApiModelProperty("订单期限")
	private Date creditPeriod;

	@ApiModelProperty("订单金额")
	private BigDecimal orderAmount;

	@ApiModelProperty("运营id")
	private Integer operationId;

	@ApiModelProperty("合同编号")
	private String contractNo;

	@ApiModelProperty(value = "收货信息")
	private UserAddressDTO userAddress;

	@ApiModelProperty("合同状态状态：状态:（0:等待用户签署、1：用户签署失败、2：等待甲方签署(用户签署成功) 3：用户签署失败、4：甲方签署成功、5：已完成")
	private Integer signStatus;

	@ApiModelProperty(value = "合同签署方式,1:线上,0:线下")
	private Integer contractSignedWay;

	@ApiModelProperty(value = "付款期限-天数")
	private Integer creditPeriodDays;

	@ApiModelProperty(value = "运营人员")
	private String operationName;

	@ApiModelProperty(value = "标品的备注,字符不超过600")
	private String remark;

	@ApiModelProperty(value = "管理员专用备注")
	private String mRemark;

	@ApiModelProperty(value = "销售名称")
	private String saleName;

	@ApiModelProperty(value = "销售id")
	private Integer saleId;

	@ApiModelProperty("减免金额")
	private BigDecimal deductAmount;

	@ApiModelProperty("优惠金额")
	private BigDecimal discountAmount;

	@ApiModelProperty("实付金额")
	private BigDecimal realityAmount;

	@ApiModelProperty("优惠券折扣金额")
	private BigDecimal couponDiscountAmount;

	@ApiModelProperty("手填折扣金额")
	private BigDecimal manualDiscountAmount;

	@ApiModelProperty(value = "共享人id")
	private Integer shareId;

	@ApiModelProperty(value = "共享状态  0是起始状态 100接受共享中 200已共享 300其他状态")
	private Integer shareStatus;

	@ApiModelProperty(value = "订单分成状态，0未分成，1已分成")
	private Integer divide;


	public MallOrderDTO buildMallOrderDTO() {
		return MallOrderDTO.builder().id(id).orderNo(orderNo).statusCode(statusCode).createTime(createTime).uid(uid).userAccountId(userAccountId)
				.userName(userName).phoneNum(phoneNum).shutReason(shutReason).payMethod(payMethod).recMallUserName(recMallUserName).
						deliveryTime(deliveryTime).creditPeriod(creditPeriod).orderAmount(orderAmount).userAddress(userAddress).contractNo(contractNo)
						.operationId(operationId).signStatus(signStatus).deliveryTime(deliveryTime).userAddressId(userAddressId).
						contractSignedWay(contractSignedWay).operationName(operationName).remark(remark).mRemark(mRemark)
						.deductAmount(deductAmount).discountAmount(discountAmount).realityAmount(realityAmount).shareStatus(shareStatus).shareId(shareId).couponDiscountAmount(this.couponDiscountAmount)
				.manualDiscountAmount(this.manualDiscountAmount).build();
	}

	public MallOrderPageDTO buildMallOrderPageDTO() {
		return MallOrderPageDTO.builder().id(id).orderNo(orderNo).statusCode(statusCode).createTime(createTime).userAccountId(this.userAccountId).uid(uid).userName(userName)
				.phoneNum(phoneNum).payMethod(payMethod).recMallUserName(recMallUserName).deliveryTime(deliveryTime).orderAmount(orderAmount).contractNo(contractNo)
				.contractSignedWay(contractSignedWay).operationId(this.operationId).signStatus(signStatus).deliveryTime(deliveryTime).operationName(operationName)
				.remark(this.remark).creditPeriod(creditPeriod).mRemark(mRemark).saleId(saleId).saleName(saleName).shareId(shareId).shareStatus(shareStatus)
				.deductAmount(deductAmount).discountAmount(discountAmount).realityAmount(realityAmount).shutReason(this.shutReason).build();
	}

	public MallOrderFinishDTO buildMallOrderFinishDTO(){
		return MallOrderFinishDTO.builder().orderId(this.id).orderNo(this.orderNo).realityAmount(this.getRealityAmount()).divide(this.divide).userAccountId(this.userAccountId).uid(this.uid)
				.userName(this.userName).build();
	}
}
