package com.mmc.oms.dao.mall;

import com.mmc.oms.entity.mall.*;
import com.mmc.oms.model.qo.mall.MallOrderQO;
import com.mmc.oms.model.qo.mall.OrderBonusQO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/** 
* @author 作者 geDuo
* @version 创建时间：2022年3月20日 上午12:10:00 
* @explain 类说明 
*/
@Mapper
public interface MallOrderDao {

	int insertMallOrder(MallOrderDO order);

//	int batchInsertOrderGoods(List<OrderGoodsDO> list);

	int countPageAmOrder(String keyword, String orderType, Integer userAccountId);

	List<MallOrderDO> listPageAmOrder(Integer pageNo, Integer pageSize, String keyword, String orderType,
                                      Integer userAccountId);

	int countAppPageOrder(String keyword, String orderType, List<Integer> statusCodes, Integer userAccountId);

	List<MallOrderDO> listAppPageAmOrder(Integer pageNo, Integer pageSize, String keyword, String orderType,
                                         List<Integer> statusCodes, Integer userAccountId);

//	List<OrderGoodsDO> listOrderGoods(List<Long> orderIds);
//
//	List<OrderGoodsDO> listOrderGoodsInfo(Long orderId);

	MallOrderDO getMallOrderInfo(Long orderId);

	/**
	 * 获取订单付款期限，和状态(未付款)
	 * @param orderId
	 */
	List<MallOrderDO> getMallOrderCreditPeriod(List<Long> orderId);

	Integer updateMallOrder(MallOrderDO order);

	int insertOrderPay(OrderPayDO pay);

	int updateOrderPay(OrderPayDO pay);

	OrderPayDO getOrderPayInfo(Long orderId, Integer payType);

	List<MallOrderStatusDO> listOrderStatus();

	int insertOrderExpress(MallOrderExpressDO express);

	MallOrderExpressDO getOrderExpress(Long orderId);

	int countPagePmOrder(MallOrderQO param);

	List<MallOrderDO> listPagePmOrder(MallOrderQO param);

	int batchInsertOrderService(List<OrderServiceDO> list);

	List<OrderServiceDO> listOrderService(Long orderId);

	List<OrderPayDO> listOrderPay(Long orderId, Integer payType);

	int countPMOrderConfirm(Integer statusCode);
	
	String getSysOrderParam(String paramType);

	List<MallOrderDO> listExportOrder(MallOrderQO param);

    Integer deleteById(Integer id);

	List<MallOrderDO> listPagePmOrderVerOne(MallOrderQO param);

	int countPagePmOrderVerOne(MallOrderQO param);

	List<MallOrderDO> listExportOrderVerOne(MallOrderQO param);

	Integer updateMallOrderAddreId(@Param("mallOrderId") Long mallOrderId, @Param("userAddressId") Integer userAddressId);

    void updateMallOrderRemark(Long mallOrderId, String remark);

	/**
	 * 商城订单列表
	 *
	 * @param orderIds 订单id
	 * @return {@link List}<{@link MallOrderDO}>
	 */
	List<MallOrderDO> listMallOrder(List<Long> orderIds);

	List<MallOrderDO> getMallOrderByStatus(@Param("code") Integer code);

	void saveOrderPay(OrderPayDO upPay);

	Integer countOrderForCouponUse(@Param("orderIds") List<Long> orderIds, Integer orderStatus);

	MallOrderDO getOrderInfoByOrderNo(String orderNo);

	int rollbackMallOrder(MallOrderDO order);

	List<MallOrderDO> listFinishMallOrder(OrderBonusQO orderBonusQO);

	int countListFinishMallOrder(OrderBonusQO orderBonusQO);

	int countPageOrderInfo(List<Long> orderIds);

	List<MallOrderDO> listOperationalExportOrder(List<Long> orderIds);
}
