package com.mmc.oms.controller.mall;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.BaseController;
import com.mmc.oms.service.mall.MallOrderService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/** 
* @author 作者 geDuo
* @version 创建时间：2022年3月18日 下午8:08:01 
* @explain 类说明 
*/
@Api(tags = { "平台-订单管理-接口" }, hidden = true)
@RestController
@RequestMapping("/pmorder/")
public class PMOrderController extends BaseController {

	@Autowired
	private MallOrderService mallOrderService;

//	@ApiOperation(value = "(新)确认订单")
//	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
//	@PostMapping("confirmOrderVerOne")
//	public ResultBody confirmOrderVerOne(@RequestBody ConfirmOrderVO confirmOrderVO, HttpServletRequest request) {
//		return mallOrderService.confirmOrderVerOne(confirmOrderVO, this.getCurrentAccount(request));
//	}

//	@ApiOperation(value = "审批-首次收款（通过或不通过）")
//	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
//	@GetMapping("confirmCost")
//	public ResultBody confirmCost(@ApiParam(value = "订单id") @RequestParam Long orderId,
//								  @ApiParam(value = "审核状态：0拒绝/1通过") @RequestParam Integer checkStatus,
//								  @ApiParam(value = "驳回原因") @RequestParam(required = false) String refuseReason,
//								  @ApiParam(value = "支付凭证-图片") @RequestParam(required = false) List<String> vouchr,
//								  HttpServletRequest request) {
//		return mallOrderService.confirmCost(orderId, checkStatus, refuseReason,vouchr,null,this.getCurrentAccount(request));
//	}

//	@ApiOperation(value = "审批-尾款（通过或不通过）")
//	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
//	@GetMapping("confirmAfPay")
//	public ResultBody confirmAfPay(@ApiParam(value = "订单id") @RequestParam Long orderId,
//			@ApiParam(value = "审核状态：0拒绝/1通过") @RequestParam Integer checkStatus,
//			@ApiParam(value = "驳回原因") @RequestParam(required = false) String refuseReason,
//			@ApiParam(value = "支付凭证-图片") @RequestParam(required = false) List<String> vouchr,
//			HttpServletRequest request) {
//		return mallOrderService.confirmAfPay(orderId, checkStatus, refuseReason,vouchr,2, this.getCurrentAccount(request));
//	}

//	@ApiOperation(value = "审批-首次收款（通过或不通过）[新]")
//	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
//	@PostMapping("confirmCostVerOne")
//	public ResultBody confirmCostVerOne(@RequestBody @Validated ConfirmAfPayVO confirmPay, HttpServletRequest request) {
//		return mallOrderService.confirmCostVerOne(confirmPay,this.getCurrentAccount(request));
//	}
//
//	@ApiOperation(value = "审批-尾款（通过或不通过）[新]")
//	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
//	@PostMapping("confirmAfPayVerOne")
//	public ResultBody confirmAfPayVerOne(@RequestBody @Validated List<ConfirmAfPayVO> confirmPay, HttpServletRequest request) {
//		if(CollectionUtils.isEmpty(confirmPay)){
//			return ResultBody.error("参数不能为空");
//		}
//		for (ConfirmAfPayVO confirmAfPay : confirmPay) {
//			mallOrderService.confirmAfPayVerOne(confirmAfPay, this.getCurrentAccount(request));
//		}
//		return ResultBody.success();
//	}

	@ApiOperation(value = "确认库存", hidden = true)
	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
	@GetMapping("confirmInventory")
	public ResultBody confirmInventory(@RequestParam Long orderId, HttpServletRequest request) {
		return mallOrderService.confirmInventory(orderId, this.getCurrentAccount(request));
	}

//	@ApiOperation(value = "代工-上传尾款凭证")
//	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
//	@PostMapping("orderPayFinish")
//	public ResultBody orderPayFinish(@Validated(value = { Confirm.class }) @RequestBody OrderPayVO param,
//			HttpServletRequest request) {
//		return mallOrderService.orderPayFinish(param, this.getCurrentAccount(request));
//	}

//	@ApiOperation(value = "菜单红点-待处理的订单数量")
//	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
//	@GetMapping("countMenuRedPoint")
//	public ResultBody countMenuRedPoint(HttpServletRequest request) {
//		return ResultBody.success(mallOrderService.countMenuRedPoint(this.getCurrentAccount(request)));
//	}

//	@ApiOperation(value = "订单关闭-根据id")
//	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
//	@GetMapping("deleteById")
//	public ResultBody closeMallOrder(@RequestParam Long id, HttpServletRequest request) {
//		return mallOrderService.closeMallOrder(id,this.getCurrentAccount(request));
//	}

//	@ApiOperation(value = "分配运营")
//	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
//	@GetMapping("allocateOperation")
//	public ResultBody allocateOperation(@ApiParam(value = "订单id")@RequestParam(value = "orderId") Long orderId,
//										@ApiParam(value = "运营id") @RequestParam(value = "operationId") Integer operationId) {
//		return mallOrderService.allocateOperation(orderId,operationId);
//	}

}
