package com.mmc.oms.controller.mall;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.BaseController;
import com.mmc.oms.model.dto.mall.CountShowTypeDTO;
import com.mmc.oms.model.dto.mall.MallOrderDTO;
import com.mmc.oms.model.dto.mall.MallOrderPageDTO;
import com.mmc.oms.model.vo.mall.ConfirmMallOrderVO;
import com.mmc.oms.model.vo.mall.MallConfirmOrderVO;
import com.mmc.oms.service.mall.AppMallOrderService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;

/**
 * @author
 */
@Api(tags = {"小程序-订单管理-接口(改版后)"})
@RestController
@RequestMapping("/app-order/")
public class AppMallOrderController extends BaseController {

    @Autowired
    private AppMallOrderService appMallOrderService;

    @ApiOperation(value = "提交订单（意向）-改版后", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = MallOrderDTO.class)})
    @PostMapping("addMallOrder")
    public ResultBody addMallOrder(@RequestBody ConfirmMallOrderVO param, HttpServletRequest request)  throws Exception {
        return appMallOrderService.addMallOrder(param, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "订单列表-查询", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = MallOrderPageDTO.class)})
    @GetMapping("listPage")
    public ResultBody listPage(@RequestParam Integer pageNo, @RequestParam Integer pageSize,
                               @RequestParam(required = false) String keyword, @RequestParam(required = false) Integer showType,
                               @ApiParam(value = "all全部-doing进行中") @RequestParam(required = false) String orderType,
                               HttpServletRequest request) {
        return ResultBody.success(appMallOrderService.listAPPPage(pageNo, pageSize, keyword, showType, orderType, this.getCurrentAccount(request)));
    }

    @ApiOperation(value = "订单列表-数量查询", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = CountShowTypeDTO.class) })
    @GetMapping("countListPage")
    public ResultBody countListPage(HttpServletRequest request) {
        return ResultBody.success(appMallOrderService.countListPage(this.getCurrentAccount(request)));
    }

    @ApiOperation(value = "订单信息--查询订单的分享状态", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @ApiIgnore
    @GetMapping("getShareOrderStatus")
    public ResultBody getShareOrderStatus(@RequestParam @ApiParam(value = "订单id") Long orderId) {
        return appMallOrderService.getShareOrderStatus(orderId);
    }

    @ApiOperation(value = "订单信息--接受共享", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("acceptShare")
    public ResultBody acceptShare(@RequestParam @ApiParam(value = "订单id") Long orderId, @RequestParam @ApiParam(value = "分享人id") Integer shareId) {
        return appMallOrderService.acceptShare(orderId,shareId);
    }

    @ApiOperation(value = "退回合同", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("returnContractById")
    public ResultBody returnContractById(@RequestParam @ApiParam(value = "订单id") Long orderId) {
        return appMallOrderService.returnContractById(orderId);
    }

    @ApiOperation(value = "确认订单V1.0.0")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = MallOrderDTO.class)})
    @PostMapping("confirmMallOrder")
    public ResultBody confirmMallOrder(@RequestBody MallConfirmOrderVO param, HttpServletRequest request)  throws Exception {
        return appMallOrderService.confirmMallOrder(param, this.getCurrentAccount(request), request.getHeader("token"));
    }

    @ApiOperation(value = "提交订单V1.0.0")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = MallOrderDTO.class)})
    @PostMapping("commitMallOrder")
    public ResultBody commitMallOrder(@RequestBody MallConfirmOrderVO param, HttpServletRequest request)  throws Exception {
        return appMallOrderService.commitMallOrder(param, this.getCurrentAccount(request), request.getHeader("token"));
    }

    @ApiOperation(value = "订单详情V1.0.0", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = MallOrderDTO.class) })
    @GetMapping("getMallOrderDetailById")
    public ResultBody getMallOrderDetailById(@RequestParam Long orderId, HttpServletRequest request) {
        return ResultBody.success(appMallOrderService.getMallOrderDetailById(orderId,this.getCurrentAccount(request)));
    }
}
