package com.mmc.oms.controller.mall;

import com.mmc.oms.common.publicinterface.Auto;
import com.mmc.oms.common.publicinterface.Confirm;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.BaseController;
import com.mmc.oms.model.vo.mall.OrderPayVO;
import com.mmc.oms.service.mall.MallOrderService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author 作者 geDuo
 * @version 创建时间：2022年3月18日 下午8:09:54
 * @explain 类说明
 */
//@Api(tags = { "小程序-订单管理-接口" })
@RestController
@RequestMapping("/amorder/")
public class AMOrderController extends BaseController {

	@Autowired
	private MallOrderService mallOrderService;

//	@ApiOperation(value = "订单列表-查询")
//	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = MallOrderDTO.class) })
//	@GetMapping("listPage")
//	public ResultBody listPage(@RequestParam Integer pageNo, @RequestParam Integer pageSize,
//                               @RequestParam(required = false) String keyword, @RequestParam(required = false) Integer showType,
//                               @ApiParam(value = "all全部-doing进行中") @RequestParam(required = false) String orderType,
//                               HttpServletRequest request) {
//		return ResultBody.success(mallOrderService.listPage(pageNo, pageSize, keyword, orderType, this.getCurrentAccount(request)));
//	}

	@ApiOperation(value = "首次付款-上传支付凭证/重新上传支付凭证", hidden = true)
	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
	@PostMapping("orderPay")
	public ResultBody orderPay(@Validated(value = { Confirm.class }) @RequestBody OrderPayVO param, HttpServletRequest request) {
		return mallOrderService.orderPay(param, this.getCurrentAccount(request));
	}

	@ApiOperation(value = "重新上传尾款与验收凭证(新)", hidden = true)
	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
	@PostMapping("afterPayAndCheck")
	public ResultBody afterPayAndCheck(@Validated(value = { Confirm.class }) @RequestBody List<OrderPayVO> param, HttpServletRequest request) {
		return mallOrderService.afterPayAndCheck(param, this.getCurrentAccount(request));
	}

	@ApiOperation(value = "继续上传全款、预付款、尾款、验收凭证", hidden = true)
	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
	@PostMapping("continuePayAndCheck")
	public ResultBody continuePayAndCheck(@Validated(value = { Confirm.class }) @RequestBody List<OrderPayVO> param, HttpServletRequest request) {
		return mallOrderService.continuePayAndCheck(param, this.getCurrentAccount(request));
	}

	@ApiOperation(value = "确认收货", hidden = true)
	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
	@PostMapping("confirmReceipt")
	public ResultBody confirmReceipt(@Validated(value = { Auto.class }) @RequestBody OrderPayVO param,
			HttpServletRequest request) {
		return mallOrderService.confirmReceipt(param, this.getCurrentAccount(request));
	}

	@ApiOperation(value = "取消订单", hidden = true)
	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
	@GetMapping("closeOrder")
	public ResultBody closeOrder(@RequestParam Long orderId, @RequestParam(required = false) String shutReason,
                                 HttpServletRequest request) {
		return mallOrderService.closeOrder(orderId, shutReason, this.getCurrentAccount(request));
	}

//	@ApiOperation(value = "订单详情")
//	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = MallOrderDTO.class) })
//	@GetMapping("orderDetail")
//	public ResultBody orderDetail(@RequestParam Long orderId, HttpServletRequest request) {
//		return ResultBody.success(mallOrderService.appOrderDetail(orderId,this.getCurrentAccount(request)));
//	}

	@ApiOperation(value = "发送服务消息通知", hidden = true)
	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
	@GetMapping("sendOrderStatusChangeMsg")
	public void sendOrderStatusChangeMsg(@RequestParam Long orderId) {
		mallOrderService.sendOrderStatusChangeMsg(orderId);
	}
}
