package com.mmc.oms.controller;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.model.dto.kdn.KdnDicDTO;
import com.mmc.oms.model.dto.order.ExpressInfoDTO;
import com.mmc.oms.model.dto.order.OrderInfoDTO;
import com.mmc.oms.model.dto.order.OrderReceiptDTO;
import com.mmc.oms.model.dto.transtatus.TranStatusDicDTO;
import com.mmc.oms.service.OrderLogisticsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author small
 * @Date 2023/5/31 16:14
 * @Version 1.0
 */
@Api(tags = {"订单-物流-接口"})
@RestController
@RequestMapping("/express/")
public class OrderLogisticsController extends BaseController {

    @Autowired
    private OrderLogisticsService orderLogisticsService;

    @ApiOperation(value = "物流-状态码-字典")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = TranStatusDicDTO.class)})
    @GetMapping("listKdnDic")
    public ResultBody<KdnDicDTO> listKdnDic() {
        return ResultBody.success(orderLogisticsService.listKdnDic());
    }

    @ApiOperation(value = "v1.0.1 物流公司列表-字典")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = TranStatusDicDTO.class)})
    @GetMapping("listExpressInfo")
    public ResultBody<ExpressInfoDTO> listExpressInfo() {
        return ResultBody.success(orderLogisticsService.listExpressInfo());
    }

    @ApiOperation(value = "v1.0.1查询订单的发货、收货、退换货等信息——用户信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = OrderReceiptDTO.class)})
    @GetMapping("getOrderExpress")
    public ResultBody<OrderReceiptDTO> getOrderExpress(@RequestParam Integer orderInfoId) {
        return ResultBody.success(orderLogisticsService.getOrderReceiptInfo(orderInfoId));
    }

    @ApiOperation(value = "查看发货物流信息-订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = OrderInfoDTO.class)})
    @GetMapping("orderExpressInfo")
    public ResultBody<OrderInfoDTO> orderExpressInfo(@RequestParam Integer orderInfoId) {
        return orderLogisticsService.orderExpressInfo(orderInfoId);
    }

    @ApiOperation(value = "查看退货物流信息-订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = OrderInfoDTO.class)})
    @GetMapping("refundExpressInfo")
    public ResultBody<OrderInfoDTO> refundExpressInfo(@RequestParam Integer orderInfoId) {
        return orderLogisticsService.refundExpressInfo(orderInfoId);
    }
}
