package com.mmc.oms.common.util;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author small
 * @Date 2023/5/31 16:51
 * @Version 1.0
 */
public class KdnExpressUtil {
    // 用户ID，快递鸟提供，注意保管，不要泄漏
    private static String EBusinessID = "1741818";// 即用户ID，登录快递鸟官网会员中心获取
    // https://www.kdniao.com/UserCenter/v4/UserHome.aspx
    // API key，快递鸟提供，注意保管，不要泄漏
    private static String ApiKey = "d02b4c1e-2c59-46a5-859d-4c7832aad03c";// 即API key，登录快递鸟官网会员中心获取
    // https://www.kdniao.com/UserCenter/v4/UserHome.aspx
    // 请求url, 正式环境地址
    private static String ReqURL = "https://api.kdniao.com/Ebusiness/EbusinessOrderHandle.aspx";
    //订阅推送请求url, 正式环境地址
    private static String KdApiSearchMonitorPushReqURL = "https://api.kdniao.com/api/dist";

    public static void main(String[] args) {
        try {
            System.out.println(KdnExpressUtil.SF("15858341767", "SF11319617182224329"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * https://www.kdniao.com/api-trackexpress
     *
     * @param phone
     * @param logisticCode
     * @return
     * @throws Exception
     */
    public static String SF(String phone, String logisticCode) throws Exception {
        //
        String phone4 = phone.substring(phone.length() - 4, phone.length());
        return KdnExpressUtil.orderOnlineByJson(phone4, "SF", logisticCode);
    }

    /**
     * https://www.kdniao.com/api-trackexpress
     *
     * @param shopCode
     * @param logisticCode
     * @return
     * @throws Exception
     */
    public static String JD(String shopCode, String logisticCode) throws Exception {
        // shopCode:京东的青龙配送码，貌似随便填也可以
        return KdnExpressUtil.orderOnlineByJson(shopCode, "JD", logisticCode);
    }

    public static String others(String exCode, String logisticCode) throws Exception {
        // shopCode:京东的青龙配送码，貌似随便填也可以
        return KdnExpressUtil.orderOnlineByJson("", exCode, logisticCode);
    }

    public static String monitorPush(String port, Long orderId, String shipperCode, String logisticCode, String phone) throws Exception {
        String callbackTag = port + "-" + orderId;
        String customerName = phone.substring(phone.length() - 4, phone.length());
        return kdApiSearchMonitorPush(callbackTag, shipperCode, logisticCode, customerName);
    }

    /**
     * 快递查询接口
     *
     * @param logisticCode-物流单号
     * @return
     * @throws Exception
     */
    public static String orderOnlineByJson(String customerName, String shipperCode, String logisticCode)
            throws Exception {
        // 组装应用级参数
        String RequestData = "{" + "'OrderCode': ''," + "'CustomerName': '" + customerName + "'," + "'LogisticCode': '"
                + logisticCode
                + "',"
                + "'ShipperCode': '" + shipperCode + "'}";
        // 组装系统级参数
        Map<String, String> params = new HashMap<String, String>();
        params.put("RequestData", urlEncoder(RequestData, "UTF-8"));
        params.put("EBusinessID", EBusinessID);
        params.put("RequestType", "8003");// 快递查询接口指令8002/地图版快递查询接口指令8004
        String dataSign = encrypt(RequestData, ApiKey, "UTF-8");
        params.put("DataSign", urlEncoder(dataSign, "UTF-8"));
        params.put("DataType", "2");
        // 以form表单形式提交post请求，post请求体中包含了应用级参数和系统级参数
        String result = sendPost(ReqURL, params);

        // 根据公司业务处理返回的信息......
        return result;
    }

    /**
     * 物流跟踪接口(增值版)
     *
     * @param callbackTag-表示端口及订单：端口/订单号
     * @param shipperCode-快递公司编码
     * @param logisticCode-快递编号
     * @param customerName-用户手机尾号4位
     * @return
     * @throws Exception
     */
    public static String kdApiSearchMonitorPush(String callbackTag, String shipperCode, String logisticCode, String customerName) throws Exception {
        // 组装应用级参数
        String RequestData = "{" +
                "'Callback':'" + callbackTag + "'," +
                "'ShipperCode':'" + shipperCode + "'," +
                "'LogisticCode':'" + logisticCode + "'," +
                "'CustomerName':'" + customerName + "'," +
                "}";
        // 组装系统级参数
        Map<String, String> params = new HashMap<String, String>();
        params.put("RequestData", urlEncoder(RequestData, "UTF-8"));
        params.put("EBusinessID", EBusinessID);
        params.put("RequestType", "8005");//在途监控订阅接口指令8008/地图版订阅接口指令8005
        String dataSign = encrypt(RequestData, ApiKey, "UTF-8");
        params.put("DataSign", urlEncoder(dataSign, "UTF-8"));
        params.put("DataType", "2");
        // 以form表单形式提交post请求，post请求体中包含了应用级参数和系统级参数
        String result = sendPost(KdApiSearchMonitorPushReqURL, params);

        //根据公司业务处理返回的信息......
        return result;
    }

    /**
     * MD5加密 str 内容 charset 编码方式
     *
     * @throws Exception
     */
    private static String MD5(String str, String charset) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(str.getBytes(charset));
        byte[] result = md.digest();
        StringBuffer sb = new StringBuffer(32);
        for (int i = 0; i < result.length; i++) {
            int val = result[i] & 0xff;
            if (val <= 0xf) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(val));
        }
        return sb.toString().toLowerCase();
    }

    /**
     * base64编码 str 内容 charset 编码方式
     *
     * @throws UnsupportedEncodingException
     */
    @SuppressWarnings("restriction")
    private static String base64(String str, String charset) throws UnsupportedEncodingException {
        String encoded = Base64.encode(str.getBytes(charset));
        return encoded;
    }

    @SuppressWarnings("unused")
    private static String urlEncoder(String str, String charset) throws UnsupportedEncodingException {
        String result = URLEncoder.encode(str, charset);
        return result;
    }

    /**
     * 电商Sign签名生成 content 内容 keyValue ApiKey charset 编码方式
     *
     * @return DataSign签名
     * @throws UnsupportedEncodingException ,Exception
     */
    @SuppressWarnings("unused")
    private static String encrypt(String content, String keyValue, String charset)
            throws UnsupportedEncodingException, Exception {
        if (keyValue != null) {
            return base64(MD5(content + keyValue, charset), charset);
        }
        return base64(MD5(content, charset), charset);
    }

    /**
     * 向指定 URL 发送POST方法的请求 url 发送请求的 URL params 请求的参数集合
     *
     * @return 远程资源的响应结果
     */
    private static String sendPost(String url, Map<String, String> params) {
        OutputStreamWriter out = null;
        BufferedReader in = null;
        StringBuilder result = new StringBuilder();
        try {
            URL realUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection) realUrl.openConnection();
            // 发送POST请求必须设置如下两行
            conn.setDoOutput(true);
            conn.setDoInput(true);
            // POST方法
            conn.setRequestMethod("POST");
            // 设置通用的请求属性
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.connect();
            // 获取URLConnection对象对应的输出流
            out = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            // 发送请求参数
            if (params != null) {
                StringBuilder param = new StringBuilder();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    if (param.length() > 0) {
                        param.append("&");
                    }
                    param.append(entry.getKey());
                    param.append("=");
                    param.append(entry.getValue());
                    System.out.println(entry.getKey() + ":" + entry.getValue());
                }
                System.out.println("param:" + param.toString());
                out.write(param.toString());
            }
            // flush输出流的缓冲
            out.flush();
            // 定义BufferedReader输入流来读取URL的响应
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            String line;
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        // 使用finally块来关闭输出流、输入流
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result.toString();
    }
}

