package com.mmc.oms.client;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mmc.oms.model.dto.mall.*;
import com.mmc.oms.model.qo.mall.MallOrderGoodsInfoQO;
import com.mmc.oms.model.qo.mall.ProductSpecPriceQO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/6/8 11:18
 */
@Component
public class PmsClient {
    @Value("${pms.url}")
    private String pmsAppUri;

    @Autowired
    private RestTemplate restTemplate;


    public List<MallGoodsShopCarDTO> fillGoodsInfo(List<MallGoodsShopCarDTO> param, String token){
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(param), headers);
        ResponseEntity<List> responseEntity = restTemplate.exchange(pmsAppUri + "goods/fillGoodsInfo", HttpMethod.POST, entity, List.class);
        if (CollectionUtils.isEmpty(responseEntity.getBody())) {
            return null;
        }
        List<MallGoodsShopCarDTO> orderGoodsProdDTO = (List<MallGoodsShopCarDTO>) responseEntity.getBody().stream().map(it->new ObjectMapper().convertValue(it,MallGoodsShopCarDTO.class)).collect(Collectors.toList());
        return orderGoodsProdDTO;
    }

    public List<OrderGoodsProdDTO> feignListProdGoodsSkuInfo(MallOrderGoodsInfoQO mallOrderGoodsInfoQO, String token){
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(mallOrderGoodsInfoQO), headers);
        ResponseEntity<List> responseEntity = restTemplate.exchange(pmsAppUri + "goods/feignListProdGoodsSkuInfo", HttpMethod.POST, entity, List.class);
        if (CollectionUtils.isEmpty(responseEntity.getBody())) {
            return null;
        }
        List<OrderGoodsProdDTO> orderGoodsProdDTO = (List<OrderGoodsProdDTO>) responseEntity.getBody().stream().map(it->new ObjectMapper().convertValue(it,OrderGoodsProdDTO.class)).collect(Collectors.toList());
        //JSONArray.parseArray(responseEntity.getBody(),OrderGoodsProdDTO.class);
        return orderGoodsProdDTO;
    }

    public List<OrderGoodsIndstDTO> feignListIndstGoodsSkuInfo(MallOrderGoodsInfoQO mallOrderGoodsInfoQO, String token){
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(mallOrderGoodsInfoQO), headers);
        ResponseEntity<List> responseEntity = restTemplate.exchange(pmsAppUri + "goods/feignListIndstGoodsSkuInfo", HttpMethod.POST, entity, List.class);
        if (CollectionUtils.isEmpty(responseEntity.getBody())) {
            return null;
        }
        List<OrderGoodsIndstDTO> indstDTOS = (List<OrderGoodsIndstDTO>) responseEntity.getBody().stream().map(it->new ObjectMapper().convertValue(it,OrderGoodsIndstDTO.class)).collect(Collectors.toList());
        return indstDTOS;
    }

    public List<MallProductSpecPriceDTO> feignListProductSpecPrice(ProductSpecPriceQO productSpecPriceQO, String token){
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(productSpecPriceQO), headers);
        ResponseEntity<List> responseEntity = restTemplate.exchange(pmsAppUri + "goods/feignListProductSpecPrice", HttpMethod.POST, entity, List.class);
        if (CollectionUtils.isEmpty(responseEntity.getBody())) {
            return null;
        }
        List<MallProductSpecPriceDTO> mallProductSpecPriceDTO = (List<MallProductSpecPriceDTO>) responseEntity.getBody().stream().map(it->new ObjectMapper().convertValue(it,MallProductSpecPriceDTO.class)).collect(Collectors.toList());
        return mallProductSpecPriceDTO;
    }

    public ProductSpecPriceDTO feignGetUnitPriceByTag(Integer specId, Integer tagId, String token){
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(null, headers);
        ResponseEntity<ProductSpecPriceDTO> responseEntity = restTemplate.exchange(pmsAppUri + "goods/feignGetUnitPriceByTag" + "?specId=" + specId + "&tagId=" + tagId, HttpMethod.GET, entity, ProductSpecPriceDTO.class);
        return responseEntity.getBody();
    }
}
