package com.mmc.oms.model.vo.mall;

import com.mmc.oms.common.publicinterface.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 商城订单
 * </p>
 *
 * @author dahang
 * @since 2022-09-05
 */
@Data
@ApiModel(value="MallOrderVO", description="商城订单")
public class MallOrderVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "订单id")
    private Integer id;

    @ApiModelProperty(value = "0全款购买 1分期付款")
    private Integer payMethod;

    @ApiModelProperty(value = "订单金额")
    private BigDecimal orderAmount;

    @ApiModelProperty(value = "订单关闭原因")
    private String shutReason;

    @ApiModelProperty(value = "订单交期")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date deliveryTime;

    @ApiModelProperty(value = "付款期限-天数")
    private Integer creditPeriodDays;

    @ApiModelProperty(value = "付款期限")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date creditPeriod;

    @ApiModelProperty(value = "推荐人id")
    private Integer recMallUserId;

    @ApiModelProperty(value = "用户收货地址id")
    private Integer userAddressId;

    @ApiModelProperty(value = "合同签署方式,1:线上,0:线下")
    private Integer contractSignedWay;

    @ApiModelProperty(value = "减免金额", hidden = true)
    private BigDecimal deductAmount;

    @ApiModelProperty(value = "优惠金额", hidden = true)
    private BigDecimal discountAmount;

    @ApiModelProperty(value = "实付金额", hidden = true)
    private BigDecimal realityAmount;

    @ApiModelProperty("（手写折扣金额）")
    @NotNull(message = "折扣金额不能为空", groups = Update.class)
    private BigDecimal manualDiscountAmount;
}
