package com.mmc.oms.model.vo.mall;

import com.mmc.oms.common.publicinterface.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/6/3 15:52
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ConfirmShopVO implements Serializable {
    private static final long serialVersionUID = 2718749736977016762L;
    @ApiModelProperty("购物车id")
    @NotNull(message = "购物车id不能为空!",groups = {Query.class})
    private Integer shopCarId;
    @ApiModelProperty(value = "区分产品或者行业，1产品，2行业", example = "1")
    @NotNull(message = "商品所属分类不能为空!",groups = {Query.class})
    private Integer directoryId;
}