package com.mmc.oms.model.vo.coupon;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/5/24 14:50
 * @Version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
//@ApiModel(value = "CouponUserVO对象", description = "优惠券兑换表VO")
public class CouponUserExchangeVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "用户id", required = true)
    private Integer uid;

    @ApiModelProperty(value = "用户Uid", required = true)
    private String uuid;

    @ApiModelProperty(value = "用户手机号", required = true)
    private String userPhone;

    @ApiModelProperty(value = "优惠券名称", required = true)
    private String couponName;

    @ApiModelProperty(value = "优惠券面值", required = true)
    private BigDecimal couponMoney;

    @ApiModelProperty(value = "兑换比例", required = true)
    private String conversionRatio;

    @ApiModelProperty(value = "兑换积分数值")
    private Long score;

    @ApiModelProperty(value = "pid")
    public Integer pid;

    @ApiModelProperty(value = "唯一id")
    public String msgId;
}
