package com.mmc.oms.model.dto.mall;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * author:zhenjie
 * Date:2022/11/25
 * time:20:59
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "com.mmc.csf.mall.dto.MallOrderProdListDTO", description = "无人机城PC订单产品列表")
public class MallOrderProdListDTO implements Serializable {
    private static final long serialVersionUID = 2825582287124124679L;
    private Integer id;
    private Integer goodsInfoId;
    @ApiModelProperty("产品名称")
    private String productName;
    @ApiModelProperty("产品型号")
    private String model;
    @ApiModelProperty("产品sku规格名称")
    private String prodSkuSpecName;
    private String prodSkuSpecImage;
    @ApiModelProperty("料号")
    private String partNo;
    @ApiModelProperty("版本号")
    private String versionDesc;
    @ApiModelProperty("购买数量")
    private Integer buyNum;
    @ApiModelProperty("规格单价")
    private BigDecimal unitPrice;
    @ApiModelProperty("规格总价格")
    private BigDecimal skuSpecAmount;
}
