package com.mmc.oms.entity.order;

import com.mmc.oms.model.dto.OrderExpressDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/6/8 20:54
 * @Version 1.0
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
public class OrderExpressDO implements Serializable {
    private static final long serialVersionUID = 1L;

    private Integer id;
    private Long orderId;
    private String sendExpNo;
    private String sendExpCode;
    private String takeName;
    private String takePhone;
    private String takeRegion;
    private String takeAddress;
    private Date receiveTime;
    private Integer receive;
    private Date updateTime;
    private Date createTime;
    private Integer orderInfoId;
    private String sendExCode;
    private String sendExNo;
    private String region;
    private String detailAddress;
    private Integer renMethod;
    private String renPhone;
    private String renName;
    private String renExCode;
    private String renExNo;
    private String renAddress;
    private String renRepoName;
    private String renRepoAddr;
    private String renRepoPhone;


    public OrderExpressDTO buildOrderExpressDTO() {
        return OrderExpressDTO.builder().orderInfoId(orderInfoId).sendExNo(sendExNo).sendExCode(sendExCode)
                .takeName(takeName).takePhone(takePhone).region(region).detailAddress(detailAddress)
                .renPhone(renPhone).renName(renName).renExCode(renExCode).renExNo(renExNo)
                .renAddress(renAddress).renRepoName(renRepoName)
                .renRepoAddr(renRepoAddr).renRepoPhone(renRepoPhone)
                .build();
    }
}

