package com.mmc.oms.entity.mall;

import com.mmc.oms.model.dto.order.OrderCouponDTO;
import com.mmc.oms.model.vo.coupon.CouponUserVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * author:zhenjie
 * Date:2023/4/4
 * time:11:14
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OrderCouponDO implements Serializable {
    private static final long serialVersionUID = 4085601241082643413L;
    private Integer id;
    private Long orderId;
    private Integer couponUserId;
    private Integer couponType;
    private Integer useType;
    private BigDecimal useAmount;
    private Date createTime;

    public OrderCouponDTO buildOrderCouponDTO(){
        return OrderCouponDTO.builder().id(this.id).orderId(this.orderId).couponUserId(this.couponUserId).couponType(this.couponType).useType(this.useType).useAmount(this.useAmount)
                .createTime(this.createTime).couponName(buildCouponName(this.useType, this.couponType)).build();
    }

    private String buildCouponName(Integer useType, Integer couponType){
        if (useType == 1){
            return "VIP";
        }else if (useType == 2){
            if (couponType == 1){
                return "打折";
            } else if (couponType == 2) {
                return "减免";
            } else if (couponType == 3) {
                return "无门槛";
            }
        }
        return "";
    }

    public OrderCouponDO(CouponUserVO couponUserVO){
        this.orderId = couponUserVO.getCid();
        this.couponUserId = couponUserVO.getId();
        this.couponType = couponUserVO.getCouponType();
        this.useType = couponUserVO.getUseType();
        this.useAmount = couponUserVO.getUseAmount();
    }

}
