package com.mmc.oms.dao;

import com.mmc.oms.entity.coupon.CouponDO;
import com.mmc.oms.entity.coupon.CouponUserDO;
import com.mmc.oms.entity.order.*;
import com.mmc.oms.entity.transtatus.TranStatusDicDO;
import com.mmc.oms.model.qo.OrderInfoQO;
import com.mmc.oms.model.vo.order.OrderStatusVO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @Author small @Date 2023/5/26 14:47 @Version 1.0
 */
@Mapper
public interface RentalOrdersDao {
    CouponUserDO coupon(Integer couponId);

    OrderInfoDO getOrderDetail(String orderNo);

    OrderRefundDO getNewOrderRefund(Integer id);

    OrderReceiptDO getOrderReceiptInfo(Integer id);

    void insertOrderInfo(OrderInfoDO orderInfo);

    void insertOrderReceipt(OrderReceiptDO receipt);

    Integer countPcOrderInfo(OrderInfoQO param);

    List<OrderInfoDO> listPcOrderInfo(OrderInfoQO param);

    int countPageOrderInfo(OrderInfoQO param);

    List<OrderInfoDO> listPageOrderInfo(OrderInfoQO param);

    int orderStatusChanges(String orderNo, Integer tranStatus);

    OrderInfoDO getOrderInfo(Integer orderInfoId);

    void updateOrderReceipt(OrderReceiptDO receipt);

    void insertOrderVcu(OrderVcuDO vcu);

    void updateOrderInfo(OrderInfoDO upOrder);

    OrderReceiptDO getOrderReceiptByOrder(Integer orderInfoId);

    List<OrderStatusDO> listOfRentalOrders(OrderStatusVO orderStatusVO);

    int rentalOrdersCount(OrderStatusVO orderStatusVO);

    void updateOrder(String orderNo, Integer code);


    OrderRefundDO getApplicationInformation(Integer id);

    CouponDO couponMoney(Integer couponId);

    List<TranStatusDicDO> listTranStatus();

    List<OrderInfoDO> listPcOrderInfoRental(OrderInfoQO param);

    List<OrderVcuDO> orderImageDetail(String orderInfoId);
}
