package com.mmc.oms.model.qo.mall;

import com.mmc.oms.common.publicinterface.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/25 13:32
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class BUserAccountQO implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "关键字", required = false)
    private String keyword;

    @ApiModelProperty(value = "地区", required = false)
    private String area;

    @ApiModelProperty(value = "省份编码", required = false)
    private Integer provinceCode;

    @ApiModelProperty(value = "城市编码", required = false)
    private Integer cityCode;

    @ApiModelProperty(value = "县区编码", required = false)
    private Integer districtCode;

    @ApiModelProperty(value = "角色id", required = false)
    private Integer roleId;

    @ApiModelProperty(value = "账号状态：0禁用 1可用")
    private Integer accountStatus;

    @ApiModelProperty(value = "账号状态：0合伙人 1员工")
    private Integer userType;

    @ApiModelProperty(value = "用户id集合")
    private List<Integer> userIds;

    @ApiModelProperty(value = "推荐单位id")
    private Integer rcdCompanyId;

    @ApiModelProperty(value="单位集合", hidden = true)
    private List<Integer> companys;

    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
