package com.mmc.oms.controller.mall;

import com.mmc.oms.common.publicinterface.Page;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.BaseController;
import com.mmc.oms.model.dto.mall.ServiceOrderTaskDTO;
import com.mmc.oms.model.qo.mall.ServiceOrderTaskQO;
import com.mmc.oms.service.mall.ServiceOrderTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

@Api(tags = {"app-云享飞作业服务订单-模块"})
@RestController
@RequestMapping("/app/serviceOrderTask")
public class AppServiceOrderTaskController extends BaseController {

    @Autowired
    private ServiceOrderTaskService serviceOrderTaskService;

    @ApiOperation(value = "查询服务订单列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ServiceOrderTaskDTO.class)})
    @PostMapping("queryOrderTaskList")
    public ResultBody<ServiceOrderTaskDTO> queryOrderTaskList(@Validated(Page.class) @RequestBody ServiceOrderTaskQO param, HttpServletRequest request) {
        return ResultBody.success(serviceOrderTaskService.queryOrderTaskList(param, this.getCurrentAccount(request).getUserAccountId(),request));
    }
}
