package com.mmc.oms.common.result;

import com.mmc.oms.model.qo.BaseInfoQO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/5/24 15:19
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PageResult<T> implements Serializable {
    private static final long serialVersionUID = -2848996493573325801L;
    @ApiModelProperty(value = "分页起始页")
    private int pageNo;// 分页起始页
    @ApiModelProperty(value = "每页记录数")
    private int pageSize;// 每页记录数
    @ApiModelProperty(value = "返回的记录集合")
    private T list;// 返回的记录集合
    @ApiModelProperty(value = "总记录条数")
    private long totalCount;// 总记录条数
    @ApiModelProperty(value = "总页数")
    private long totalPage;// 总页数

    public static PageResult buildPage(int pageNo, int pageSize, int totalCount) {
        PageResult page = new PageResult();
        page.pageNo = pageNo;
        page.pageSize = pageSize;
        page.totalCount = totalCount;
        page.totalPage = (totalCount % pageSize == 0) ? (totalCount / pageSize) : (totalCount / pageSize + 1);
        return page;
    }

    public static <T> PageResult buildPage(int pageNo, int pageSize, int totalCount, T list) {
        PageResult page = PageResult.buildPage(pageNo, pageSize, totalCount);
        page.setList(list);
        return page;
    }

    public static PageResult buildPage(BaseInfoQO qo, int totalCount) {
        PageResult page = new PageResult();
        page.pageNo = qo.getPageNo();
        Integer pageSize = qo.getPageSize();
        page.pageSize = pageSize;
        page.totalCount = totalCount;
        page.totalPage = (totalCount % pageSize == 0) ? (totalCount / pageSize) : (totalCount / pageSize + 1);
        return page;
    }
}
