package com.mmc.oms.service.data.impl;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.dao.lease.LeaseOrderDao;
import com.mmc.oms.dao.uav.UavOrderDao;
import com.mmc.oms.feign.ImsAppApi;
import com.mmc.oms.model.dto.data.OrderReportDTO;
import com.mmc.oms.model.dto.data.ReleaseReportDTO;
import com.mmc.oms.service.data.OrderReportService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;

/**
 * @Author LW
 * @date 2023/9/19 10:05
 * 概要：
 */
@Service
public class OrderReportServiceImpl implements OrderReportService {
    @Resource
    private UavOrderDao uavOrderDao;
    @Resource
    private ImsAppApi imsAppApi;
    @Resource
    private LeaseOrderDao leaseOrderDao;

    @Override
    public ResultBody<OrderReportDTO> getOrderReportData() {
        OrderReportDTO orderReportDTO = new OrderReportDTO();
        // 获取商城订单数量
        int saleOrderCount = uavOrderDao.getOrderCount();
        orderReportDTO.setSaleOrderCount(saleOrderCount);
        // 获取租赁订单数量
        int leaseOrderCount = leaseOrderDao.getLeaseOrderCount();
        orderReportDTO.setLeaseOrderCount(leaseOrderCount);
        // 获取服务订单总数
        ResultBody<ReleaseReportDTO> userReportData = imsAppApi.getUserReportData();
        int serviceOrderCount = userReportData.getResult().getOrderReleaseCount();
        orderReportDTO.setServiceOrderCount(serviceOrderCount);
        // 获取商城订单GMV
        BigDecimal saleGMV = uavOrderDao.getSaleOrderGMV();
        orderReportDTO.setSaleGMV(saleGMV);
        // 获取租赁订单GMV
        BigDecimal leaseGMV = leaseOrderDao.getLeaseOrderGMV();
        orderReportDTO.setLeaseGMV(leaseGMV);
        BigDecimal serviceGMV = userReportData.getResult().getServiceOrderAmount();
        orderReportDTO.setServiceGMV(serviceGMV);
        // 获取总GMV
        orderReportDTO.setTotalGMV(saleGMV.add(leaseGMV).add(serviceGMV));
        return ResultBody.success(orderReportDTO);
    }
}
