package com.mmc.oms.mq.listener;

import com.alibaba.fastjson.JSONObject;
import com.mmc.oms.common.ResultEnum;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.dao.topup.TopUpOrderDao;
import com.mmc.oms.entity.topup.TopUpOrderDO;
import com.mmc.oms.model.dto.ContractInfoDTO;
import com.mmc.oms.model.vo.wallet.TopUpOrderVO;
import com.mmc.oms.mq.constant.RabbitmqConstant;
import com.mmc.oms.service.uav.UavOrderService;
import com.mmc.oms.service.uav.UavPOService;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @Author LW
 * @date 2023/6/29 10:35 概要：
 */
@Slf4j
@Component
public class MqConsumer {
    @Resource
    TopUpOrderDao topUpOrderDao;

    @Resource
    private UavOrderService uavOrderService;

    @Resource
    private UavPOService uavPOService;

    @RabbitListener(queues = RabbitmqConstant.USER_TOP_UP_DIRECT_QUEUE)
    public void subscribeDirectQueue(@Payload String topUpOrder, Channel channel, Message message) {
        TopUpOrderVO topUpOrderVO = JSONObject.parseObject(topUpOrder, TopUpOrderVO.class);
        log.info("<==========用户充值订单消费开始：订单信息是---->{}==========>", topUpOrderVO);
        // 根据消费的消息修改充值订单的信息
        TopUpOrderDO topUpOrderDO = new TopUpOrderDO();
        topUpOrderDO.setTradeState(topUpOrderVO.getTradeState());
        topUpOrderDO.setTradeStateDesc(topUpOrderVO.getTradeStateDesc());
        topUpOrderDO.setOrderNo(topUpOrderVO.getOrderNo());
        topUpOrderDao.updateTopUpOrderInfo(topUpOrderDO);
        log.info("<==========用户充值订单消费结束==========>");
    }

    @RabbitListener(queues = RabbitmqConstant.PAY_UAV_ORDER_SUCCESS_QUEUE)
    public void subscribePayUavOrderDirectQueue(@Payload String topUpOrder, Channel channel, Message message) {
        TopUpOrderVO topUpOrderVO = JSONObject.parseObject(topUpOrder, TopUpOrderVO.class);
        log.info("<==========商城支付消息消费开始：信息是---->{}==========>", topUpOrderVO);
        // 根据支付消息修改订单状态
        uavOrderService.payUavOrder(topUpOrderVO);
        log.info("<==========商城支付消息消费结束==========>");
    }

    @RabbitListener(queues = RabbitmqConstant.ORDER_SIGN_FINISH_QUEUE)
    public void finishOrderSign(@Payload String contractInfoDTO, Channel channel, Message message) {
        ContractInfoDTO contract = JSONObject.parseObject(contractInfoDTO, ContractInfoDTO.class);
        log.info("<==========合同签署完成：信息是---->{}==========>", contract);
        // 根据支付消息修改订单状态
        String orderNo = contract.getOrderNo();
        if (orderNo.startsWith("UD")) {
            uavOrderService.uavOrderFinishSign(orderNo);
        } else if (orderNo.startsWith("UP")) {
            uavPOService.uavPOFinishSign(orderNo);
        }
        log.info("<==========合同签署完成，消息消费结束==========>");
    }
}
