package com.mmc.oms.model.dto.mall;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.mmc.oms.common.publicinterface.Create;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 云享飞服务订单-主表
 * </p>
 *
 * @author Pika
 * @since 2023-06-10
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ServiceOrderTaskDTO implements Serializable {

    private static final long serialVersionUID = -178678654L;

    @ApiModelProperty(value = "订单id")
    private Integer id;

    @ApiModelProperty(value = "订单编号")
    private String orderNo;

    @ApiModelProperty(value = "订单名称")
    private String orderName;

    @ApiModelProperty(value = "订单总金额")
    private BigDecimal orderAmt;

    @ApiModelProperty(value = "订单状态,目前有用户端，飞手端，平台端")
    private Integer orderStatus;

    @ApiModelProperty(value = "手机号")
    private String phoneNum;

    @ApiModelProperty(value = "用户uid")
    private String uid;

    @ApiModelProperty(value = "用户名称")
    private String userName;

    @ApiModelProperty(value = "用户昵称")
    private String nickName;

    @ApiModelProperty(value = "用户id")
    private Integer userId;

    @ApiModelProperty(value = "服务项ID",example = "1")
    @NotNull(message = "新增服务-id不能为空", groups = {Create.class})
    private Integer inspectionId;

    @ApiModelProperty(value = "预计服务开始时间")
    @NotNull(message = "新增服务-预计服务开始时间不能为空", groups = {Create.class})
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date startTime;

    @ApiModelProperty(value = "预计服务结束时间")
    @NotNull(message = "新增服务-预计服务结束时间不能为空", groups = {Create.class})
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date endTime;

    @ApiModelProperty(value = "省份",example = "广东")
    @NotBlank(message = "新增服务-省份不能为空", groups = {Create.class})
    private String province;

    @ApiModelProperty(value = "市",example = "深圳")
    @NotBlank(message = "新增服务-市不能为空", groups = {Create.class})
    private String city;

    @ApiModelProperty(value = "详细地址",example = "西丽街道")
    @NotBlank(message = "新增服务-详细地址不能为空", groups = {Create.class})
    private String address;

    @ApiModelProperty(value = "经度",example = "117.257370")
    @NotNull(message = "新增服务-经度不能为空", groups = {Create.class})
    private BigDecimal lon;

    @ApiModelProperty(value = "纬度",example = "32.050774")
    @NotNull(message = "新增服务-纬度不能为空", groups = {Create.class})
    private BigDecimal lat;

    @ApiModelProperty(value = "任务描述")
    private String taskDescription;

    @ApiModelProperty(value = "图片")
    private List<String> images;

    @ApiModelProperty(value = "行业服务-封面图")
    private String coverPlan;

    @ApiModelProperty(value = "行业服务-分享卡片")
    private String shareCard;

    @ApiModelProperty(value = "行业服务-视频")
    private String video;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createdTime;
}
