package com.mmc.oms.service.mall;


import com.mmc.oms.common.result.PageResult;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.entity.mall.MallOrderDO;
import com.mmc.oms.model.dto.mall.MallOrderDTO;
import com.mmc.oms.model.dto.mall.MallOrderPageDTO;
import com.mmc.oms.model.dto.mall.MallStatusDTO;
import com.mmc.oms.model.dto.mall.OrderPayDTO;
import com.mmc.oms.model.dto.user.BaseAccountDTO;
import com.mmc.oms.model.qo.mall.MallOrderQO;
import com.mmc.oms.model.vo.mall.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;
import java.util.List;

/** 
* @author 作者 geDuo
* @version 创建时间：2022年3月20日 下午7:09:06 
* @explain 类说明 
*/
public interface MallOrderService {

	List<MallStatusDTO> listOrderStatus();

//	PageResult listPage(Integer pageNo, Integer pageSize, String keyword, String orderType, BaseAccountDTO cuser); // 小程序分页

	/**
	 * 买家上传支付凭证-已确认（待上传支付凭证）》已上传支付凭证（待确认收款）
	 * 
	 * @param param
	 * @param cuser
	 * @return
	 */
	ResultBody orderPay(OrderPayVO param, BaseAccountDTO cuser);// 买家上传支付凭证

	ResultBody afterPay(OrderPayVO param, BaseAccountDTO cuser);

	ResultBody orderPayFinish(OrderPayVO param, BaseAccountDTO cuser);// 平台上传尾款凭证--》订单完成

	/**
	 * 平台确认收款-已上传支付凭证（待确认收款）》已确认收款（待确认库存）
	 * @param orderId
	 * @param checkStatus
	 * @param refuseReason
	 * @param vouchr
	 * @param type
	 * @param cuser
	 * @return
	 */
	ResultBody confirmCost(Integer orderId, Integer checkStatus, String refuseReason, List<String> vouchr, Integer type, BaseAccountDTO cuser);// 平台确认收款

	ResultBody confirmAfPay(Integer orderId, Integer checkStatus, String refuseReason, List<String> vouchr, Integer type, BaseAccountDTO cuser);

	/**
	 * 平台确认库存-已确认收款（待确认库存）》已确认库存（待发货）
	 * 
	 * @param orderId
	 * @param cuser
	 * @return
	 */
	ResultBody confirmInventory(Integer orderId, BaseAccountDTO cuser);// 平台确认库存

	/**
	 * 买家确认收货-已发货（待收货）》已收货（待订单完成）
	 * @param param
	 * @param cuser
	 * @return
	 */
	ResultBody confirmReceipt(OrderPayVO param, BaseAccountDTO cuser);// 买家确认收货

	/**
	 * 取消订单
	 */
	ResultBody closeOrder(Integer orderId, String shutReason, BaseAccountDTO cuser);

	/**
	 * 订单详情
	 */
//	MallOrderDTO orderDetail(Long orderId, BaseAccountDTO cuser);

	/**
	 * 订单详情--小程序
	 */
//	MallOrderDTO appOrderDetail(Long orderId, BaseAccountDTO cuser);

	List<OrderPayDTO> listOrderPayInfo(Integer orderId, Integer payType, BaseAccountDTO cuser);

	int countMenuRedPoint(BaseAccountDTO cuser);

	ResultBody confirmOrderVerOne(ConfirmOrderVO confirmOrderVO, BaseAccountDTO currentAccount);

	void sendOrderStatusChangeMsg(Integer mallOrderId);

	/**
	 * 关闭订单
	 * @param id
	 * @param baseAccountDTO
	 * @return
	 */
	ResultBody closeMallOrder(Integer id, BaseAccountDTO baseAccountDTO);

	ResultBody updateMallOrder(Integer orderId, Date singerTime);

    ResultBody allocateOperation(Integer orderId , Integer operationId);

	ResultBody afterPayAndCheck(List<OrderPayVO> param, BaseAccountDTO currentAccount);

	ResultBody continuePayAndCheck(List<OrderPayVO> param, BaseAccountDTO currentAccount);

	void confirmAfPayVerOne(ConfirmAfPayVO confirmPay, BaseAccountDTO currentAccount);

	ResultBody confirmCostVerOne(ConfirmAfPayVO confirmPay, BaseAccountDTO currentAccount);

	ResultBody updateStatusMallOrder(Integer orderId, Integer signStatus);

	void mallOrderCreditPeriodTask();


	PageResult listPageManagerVerOne(MallOrderQO param, BaseAccountDTO currentAccount, String token);

	List<MallOrderPageDTO> buildMallOrderPageDTO(List<MallOrderDO> list, String token);

	void listPageManagerExportVerOne(MallOrderQO param, HttpServletResponse response, BaseAccountDTO currentAccount, String token);

	MallOrderDTO getMallOrderDetailById(Integer orderId, BaseAccountDTO currentAccount, String token);

	ResultBody updateMallOrderRemark(Integer orderId, String remark);

	ResultBody confirmOrderNew(ConfirmOrderNewVO confirmOrderNewVO, BaseAccountDTO currentAccount);

	ResultBody sendOrderGoodsNew(MallOrderExpressVO param, BaseAccountDTO currentAccount) throws Exception;

	void exportMultiSheet(HttpServletResponse response, List<Integer> orderIds) throws IOException;

	void listOperationalDataExport(MallOrderQO param, HttpServletResponse response, BaseAccountDTO currentAccount, String token) throws IOException;

	ResultBody feignOrderUseCoupon(List<Integer> orderIds);

    ResultBody getOrderInfoByOrderNo(String orderNo);

	void operationalDataExport(List<Integer> orderIds, HttpServletResponse response, BaseAccountDTO currentAccount) throws IOException;
}
