package com.mmc.oms.service.mall;


import com.mmc.oms.common.result.PageResult;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.entity.mall.MallIndstShopCarDO;
import com.mmc.oms.entity.mall.MallProdShopCarDO;
import com.mmc.oms.model.dto.mall.ConfirmGoodsInfoDTO;
import com.mmc.oms.model.dto.mall.CountShowTypeDTO;
import com.mmc.oms.model.dto.mall.MallOrderDTO;
import com.mmc.oms.model.dto.user.BaseAccountDTO;
import com.mmc.oms.model.dto.user.UserAccountSimpleDTO;
import com.mmc.oms.model.vo.mall.ConfirmMallOrderVO;
import com.mmc.oms.model.vo.mall.MallConfirmOrderVO;

import java.util.List;

/**
 * author:zhenjie
 * Date:2022/10/18
 * time:16:07
 */
public interface AppMallOrderService {
    ResultBody addMallOrder(ConfirmMallOrderVO param, BaseAccountDTO currentAccount) throws Exception;

    ResultBody<ConfirmGoodsInfoDTO> confirmShop(List<MallProdShopCarDO> mallProdShopCarDOS, List<MallIndstShopCarDO> mallIndstShopCarDOS, UserAccountSimpleDTO userAccountSimpleDTO);

    PageResult listAPPPage(Integer pageNo, Integer pageSize, String keyword, Integer showType, String orderType, BaseAccountDTO currentAccount, String token);


    /**
     * 得到分享订单状态
     *
     * @param orderId 订单id
     * @return {@link ResultBody}
     */
    ResultBody getShareOrderStatus(Integer orderId);

    /**
     * 接受分享
     *
     * @param orderId 订单id
     * @param shareId 共享id
     * @return {@link ResultBody}
     */
    ResultBody acceptShare(Integer orderId, Integer shareId);

    CountShowTypeDTO countListPage(BaseAccountDTO currentAccount);

    ResultBody returnContractById(Integer orderId);

    /**
     * v1.0.0确认订单
     * @param param
     * @param currentAccount
     * @param token
     * @return
     */
    ResultBody confirmMallOrder(MallConfirmOrderVO param, BaseAccountDTO currentAccount, String token);

    /**
     * v1.0.0提交订单
     * @param param
     * @param currentAccount
     * @param token
     * @return
     */
    ResultBody commitMallOrder(MallConfirmOrderVO param, BaseAccountDTO currentAccount, String token);

    /**
     * v1.0.0订单详情
     * @param orderId
     * @param currentAccount
     * @return
     */
    MallOrderDTO getMallOrderDetailById(Integer orderId, BaseAccountDTO currentAccount);
}
