package com.mmc.oms.model.dto.uav;

import com.mmc.oms.model.dto.kdn.KdnExpDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/9/4 14:50
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "最新版-订单")
public class UavOrderDTO implements Serializable {
    private static final long serialVersionUID = 7548192478886457453L;
    @ApiModelProperty("id")
    private Integer id;
    @ApiModelProperty("订单编号")
    private String orderNo;
    @ApiModelProperty("订单状态")
    private Integer statusCode;
    @ApiModelProperty("买家id")
    private Integer userAccountId;
    @ApiModelProperty("卖家id")
    private Integer thirdBackUserAccountId;
    @ApiModelProperty("卖家企业名称")
    private String companyName;
    @ApiModelProperty("订单实付总额")
    private BigDecimal orderTotalAmount;
    @ApiModelProperty("抵扣佣金余额")
    private BigDecimal salaryAmount;
    @ApiModelProperty("抵扣云享金余额")
    private BigDecimal shareAmount;
    @ApiModelProperty("其他方式支付额度")
    private BigDecimal otherAmount;
    @ApiModelProperty("wechatpay微信，alipay支付宝，offline线下")
    private String payType;
    @ApiModelProperty("订单类型，0正常订单、1意向订单")
    private Integer orderType;
    @ApiModelProperty("订单交期")
    private Date deliveryTime;
    @ApiModelProperty("收货地址id")
    private Integer userAddressId;
    @ApiModelProperty("买家备注")
    private String userRemark;
    @ApiModelProperty("卖家备注")
    private String sellerRemark;
    @ApiModelProperty("下单时间")
    private Date createTime;
    @ApiModelProperty("支付时间")
    private Date payTime;
    @ApiModelProperty("确认收货时间")
    private Date confirmReceiptTime;
    @ApiModelProperty("修改版本")
    private Integer version;
    @ApiModelProperty("评价状态")
    private Integer remarkStatus;
    @ApiModelProperty("最近修改时间")
    private Date updateTime;
    @ApiModelProperty("用户收货地址信息")
    private UavOrderExpressDTO uavOrderExpressDTO;
    @ApiModelProperty("快递信息")
    private KdnExpDTO kdnExpDTO;
    @ApiModelProperty("用户支付凭证")
    private List<UavOrderPayDTO> payDTOList;
    @ApiModelProperty("订单规格列表")
    private List<UavOrderSkuDTO> skuDTOList;

}
