package com.mmc.oms.feign.hystrix;

import com.alibaba.fastjson2.JSONObject;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.feign.UserAppApi;
import com.mmc.oms.model.dto.uav.PayWalletDTO;
import com.mmc.oms.model.vo.uav.PayUavWalletVO;
import com.mmc.oms.model.vo.wallet.TopUpOrderVO;
import lombok.extern.slf4j.Slf4j;

/**
 * @author: zj
 * @Date: 2023/5/18 17:08
 */
@Slf4j
public class UserAppApiHystrix implements UserAppApi {

    @Override
    public ResultBody feignTopUpCash(TopUpOrderVO topUpOrderVO) {
        log.error("熔断：UserAppApiHystrix.feignTopUpCash==error==>param:{}", topUpOrderVO);
        return ResultBody.error("-1", "远程调用失败");
    }

    @Override
    public ResultBody<PayWalletDTO> getCurrentUserPayWalletInfo(String token) {
        log.error("熔断：UserAppApiHystrix.getCurrentUserPayWalletInfo==error");
        return ResultBody.error("-1", "远程调用失败");
    }

    @Override
    public ResultBody feignPayUavWallet(PayUavWalletVO payUavWalletVO, String token) {
        log.error("熔断：UserAppApiHystrix.feignPayUavWallet==error==>param:{}", JSONObject.toJSONString(payUavWalletVO));
        return ResultBody.error("-1", "远程调用失败");
    }

    @Override
    public ResultBody getManagerIdByBackUserId(Integer backUserAccountId, String token) {
        log.error("熔断：UserAppApiHystrix.getManagerIdByBackUserId==error==>param:{}", JSONObject.toJSONString(backUserAccountId));
        return ResultBody.error("-1", "远程调用失败");
    }
}
