package com.mmc.oms.feign;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.feign.hystrix.UserAppApiHystrix;
import com.mmc.oms.model.dto.uav.PayWalletDTO;
import com.mmc.oms.model.vo.uav.PayUavWalletVO;
import com.mmc.oms.model.vo.wallet.TopUpOrderVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @author: zj
 * @Date: 2023/5/18 17:06
 */
@FeignClient(url = "${userapp.url}", name = "cms-svc", fallback = UserAppApiHystrix.class)
public interface UserAppApi {
    @PostMapping("pay/feignTopUpCash")
    public ResultBody feignTopUpCash(@RequestBody TopUpOrderVO topUpOrderVO);

    @GetMapping("pay/getCurrentUserPayWalletInfo")
    public ResultBody<PayWalletDTO> getCurrentUserPayWalletInfo(@RequestHeader String token);

    @PostMapping("pay/feignPayUavWallet")
    public ResultBody feignPayUavWallet(@RequestBody PayUavWalletVO payUavWalletVO, @RequestHeader String token);

    @GetMapping("company/getManagerIdByBackUserId")
    public ResultBody getManagerIdByBackUserId(@RequestParam Integer backUserAccountId, @RequestHeader String token);

}
