package com.mmc.oms.enums;

/**
 * @author: zj
 * @Date: 2023/9/4 14:36
 */
public enum UavOrderStatus {
    CONTACT(100, 200, "待意向沟通"),
    CONFIRM(200, 300, "待确认订单"),
    SIGN(300, 400, "待签署合同"),
    PAYING(400, 500,"待付款"),
    WAITING_DELIVER_GOODS(500,600, "待发货"),
    WAITING_RECEIVE_GOODS(600, 700, "待收货"),
    WAITING_REMARK(700, 800, "待评价"),
    FINISH(800, 800,"已完成"),
    CLOSE(900, 900,"已关闭")
    ;

    public Integer getCode() {
        return code;
    }

    public Integer getNextCode() {
        return nextCode;
    }

    public String getName() {
        return name;
    }

    UavOrderStatus(Integer code, Integer nextCode, String name) {
        this.code = code;
        this.nextCode = nextCode;
        this.name = name;
    }

    private Integer code;
    private Integer nextCode;
    private String name;
}
