package com.mmc.oms.entity.uav;

import com.mmc.oms.entity.mall.UserAddressDO;
import com.mmc.oms.model.dto.uav.UavOrderExpressDTO;
import com.mmc.oms.model.vo.uav.UavOrderExpressVO;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/9/4 13:53
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("最新版-订单收货地址信息")
public class UavOrderExpressDO implements Serializable {
    private static final long serialVersionUID = -8046463151711449213L;
    private Integer id;
    private Integer uavOrderId;
    private String sendExpNo;
    private String sendExpCode;
    private String takeName;
    private String takePhone;
    private String takeRegion;
    private String takeAddress;
    private Date receiveTime;
    private Integer receive;
    private Date updateTime;
    private Date createTime;

    public UavOrderExpressDO(UserAddressDO userAddressDO) {
        this.takeName = userAddressDO.getTakeName();
        this.takePhone = userAddressDO.getTakePhone();
        this.takeRegion = userAddressDO.getTakeRegion();
        this.takeAddress = userAddressDO.getTakeAddress();
    }

    public UavOrderExpressDO(UavOrderExpressVO param) {
        this.id = param.getId();
        this.uavOrderId = param.getUavOrderId();
        this.sendExpNo = param.getSendExpNo();
        this.sendExpCode = param.getSendExpCode();
        this.takeName = param.getTakeName();
        this.takePhone = param.getTakePhone();
        this.takeRegion = param.getTakeRegion();
        this.takeAddress = param.getTakeAddress();
    }

    public UavOrderExpressDTO buildUavOrderExpressDTO(){
        return UavOrderExpressDTO.builder().id(this.id).uavOrderId(this.uavOrderId).sendExpNo(this.sendExpNo).sendExpCode(this.sendExpCode).takeName(this.takeName)
                .takePhone(this.takePhone).takeAddress(this.takeAddress).takeRegion(this.takeRegion).receive(this.receive).receiveTime(this.receiveTime)
                .build();
    }
}
