package com.mmc.oms.controller.mall;

import com.mmc.oms.common.KDNCallBackResponse;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.BaseController;
import com.mmc.oms.model.dto.mall.MallStatusDTO;
import com.mmc.oms.model.dto.mall.OrderPayDTO;
import com.mmc.oms.model.dto.kdn.KdnDicDTO;
import com.mmc.oms.model.dto.order.ExpressInfoDTO;
import com.mmc.oms.service.mall.KdnExpService;
import com.mmc.oms.service.mall.MallOrderService;
import com.mmc.oms.service.mall.OrderExpressService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.Map;

/** 
* @author 作者 geDuo
* @version 创建时间：2022年3月22日 下午9:02:03 
* @explain 类说明 
*/
@Api(tags = { "订单信息-接口" })
@RestController
@RequestMapping("/mallorder/")
public class MallOrderController extends BaseController {

	@Autowired
	private MallOrderService mallOrderService;

	@Autowired
	private OrderExpressService orderExpressService;

	@Autowired
	private KdnExpService kdnExpService;

	@ApiOperation(value = "订单状态-字典")
	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = MallStatusDTO.class) })
	@GetMapping("listStatus")
	public ResultBody<MallStatusDTO> listOrderStatus() {
		return ResultBody.success(mallOrderService.listOrderStatus());
	}

	@ApiOperation(value = "物流-状态码-字典")
	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = KdnDicDTO.class) })
	@GetMapping("listKdnDic")
	public ResultBody listKdnDic() {
		return ResultBody.success(kdnExpService.listKdnDic());
	}

	@ApiOperation(value = "物流公司-字典")
	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ExpressInfoDTO.class) })
	@GetMapping("listExpressInfo")
	public ResultBody listExpressInfo() {
		return ResultBody.success(orderExpressService.listExpressInfo());
	}

	@ApiOperation(value = "订单-查看支付凭证", hidden = true)
	@ApiResponses({ @ApiResponse(code = 200, message = "OK", response = OrderPayDTO.class) })
	@GetMapping("getOrderPay")
	public ResultBody getOrderPay(@RequestParam Integer orderId, @ApiParam("凭证类型(留空则全部)：0全款 1预付款 2尾款 3验收单") @RequestParam(required = false) Integer payType, HttpServletRequest request) {
		return ResultBody.success(mallOrderService.listOrderPayInfo(orderId, payType, this.getCurrentAccount(request)));
	}

	@ApiOperation(value = "修改订单的付款期限", hidden = true)
	@GetMapping("updateMallOrder")
	@ApiIgnore
	public ResultBody updateMallOrder(@RequestParam Integer orderId, @RequestParam Date singerTime){
		return mallOrderService.updateMallOrder(orderId,singerTime);
	}

	@ApiOperation(value = "修改订单的合同状态", hidden = true)
	@GetMapping("updateStatusMallOrder")
	public ResultBody updateStatusMallOrder(@RequestParam Integer orderId, @RequestParam Integer signStatus){
		return mallOrderService.updateStatusMallOrder(orderId,signStatus);
	}

	@ApiOperation(value = "物流信息回调接收", hidden = true)
	@PostMapping("callbackExpressInfo")
	public KDNCallBackResponse callbackExpressInfo(@RequestParam Map<String, Object> map){
		return kdnExpService.callbackExpressInfo(map);
	}

	@ApiOperation(value = "测试物流订阅", hidden = true)
	@GetMapping("testCallbackExpressInfo")
	public ResultBody testCallbackExpressInfo(@RequestParam String port, @RequestParam Integer orderId, @RequestParam String shipperCode,
                                              @RequestParam String logisticCode, @RequestParam String phone) throws Exception {
		return kdnExpService.testCallbackExpressInfo(port, orderId, shipperCode, logisticCode, phone);
	}

}
