package com.mmc.oms.common.util;

import java.util.Random;

/**
 * @Author small
 * @Date 2023/5/24 16:02
 * @Version 1.0
 */
public class CodeUtil {
    private static Random random = new Random();

    //  数据生成有位数字或字母的随机数
    public static String randomCode(int num) {
//      0-61  9  9+26=35  35+26 =61    65-90  97-122
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < num; i++) {
            int y = random.nextInt(62);
            if (y <= 9) {
//          数值
                sb.append(y);
            } else {
                if (y <= 35) {
//         大写字母
                    y += 55;
                } else {
//          小写字母
                    y += 61;
                }
                sb.append((char) y);
            }
        }
        return sb.toString();
    }

    /**
     * 生成随机数字
     *
     * @param length[生成随机数的长度]
     * @return
     */
    public static String getRandomNum(int length) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < length; i++) {
            sb.append(String.valueOf(random.nextInt(10)));
        }
        return sb.toString();
    }

    /**
     * 生成用户uid
     *
     * @return
     */
    public static String createUserUID() {
        return "UID" + CodeUtil.getRandomNum(7);
    }

    /**
     * 生成-现金流水账目no
     */
    public static String createPayCashNO() {
        StringBuffer sb = new StringBuffer();
        sb.append("T");
        sb.append(TDateUtil.getCurrentDateByType("yyyyMMddHHmm"));
        sb.append(CodeUtil.getRandomNum(4));
        return sb.toString();
    }

    /**
     * 生成-信用流水账目no
     */
    public static String createPayCreditNo() {
        StringBuffer sb = new StringBuffer();
        sb.append("T");
        sb.append(TDateUtil.getCurrentDateByType("yyyyMMddHHmm"));
        sb.append(CodeUtil.getRandomNum(4));
        return sb.toString();
    }

    /**
     * 生成-飞手工资流水账目no
     */
    public static String createPayWagNo() {
        StringBuffer sb = new StringBuffer();
        sb.append("T");
        sb.append(TDateUtil.getCurrentDateByType("yyyyMMddHHmm"));
        sb.append(CodeUtil.getRandomNum(4));
        return sb.toString();
    }

    /**
     * 生成订单no
     */
    public static String createOrderTaskNO() {
        StringBuffer sb = new StringBuffer();
        sb.append("D");
        sb.append(TDateUtil.getCurrentDateByType("yyyyMMddHHmm"));
        sb.append(CodeUtil.getRandomNum(4));
        return sb.toString();
    }

    /**
     * 生成-信用返利账目no
     */
    public static String createPayRebateNo() {
        StringBuffer sb = new StringBuffer();
        sb.append("T");
        sb.append(TDateUtil.getCurrentDateByType("yyyyMMddHHmm"));
        sb.append(CodeUtil.getRandomNum(4));
        return sb.toString();
    }

    /**
     * 生成行业no
     */
    public static String createIndustryNO() {
        StringBuffer sb = new StringBuffer();
        sb.append("HY");
        sb.append(TDateUtil.getCurrentDateByType("yyyyMMddHHmm"));
        sb.append(CodeUtil.getRandomNum(4));
        return sb.toString();
    }

    /**
     * 生成服务no
     */
    public static String createInspectionNO() {
        StringBuffer sb = new StringBuffer();
        sb.append("FW");
        sb.append(TDateUtil.getCurrentDateByType("yyyyMMddHHmm"));
        sb.append(CodeUtil.getRandomNum(4));
        return sb.toString();
    }

    /**
     * 生成服务no
     */
    public static String createRoleNo() {
        StringBuffer sb = new StringBuffer();
        sb.append("JS");
        sb.append(CodeUtil.getRandomNum(4));
        return sb.toString();
    }

    /**
     * 生成商品编号
     *
     * @return
     */
    public static String createWareID() {
        return "ID" + CodeUtil.getRandomNum(10);
    }

    /**
     * 生成云仓订单编号
     */
    public static String createRepoOrderNo() {
        StringBuffer sb = new StringBuffer();
        sb.append("R");
        sb.append(TDateUtil.getCurrentDateByType("yyyyMMddHHmm"));
        sb.append(CodeUtil.getRandomNum(4));
        return sb.toString();
    }

    /**
     * 云仓现金流水
     */
    public static String createRepoCashNo() {
        StringBuffer sb = new StringBuffer();
        sb.append("J");
        sb.append(TDateUtil.getCurrentDateByType("yyyyMMddHHmm"));
        sb.append(CodeUtil.getRandomNum(4));
        return sb.toString();
    }

    /**
     * 生成商品编号
     *
     * @return
     */
    public static String createDeviceCode() {
        return "DC" + CodeUtil.getRandomNum(6);
    }

    /**
     * 云仓现金流水
     */
    public static String createOrderRefund() {
        StringBuffer sb = new StringBuffer();
        sb.append("RD");
        sb.append(TDateUtil.getCurrentDateByType("yyyyMMddHHmm"));
        sb.append(CodeUtil.getRandomNum(4));
        return sb.toString();
    }

    /**
     * 返祖订单号
     */
    public static String createShareOrderNo() {
        StringBuffer sb = new StringBuffer();
        sb.append("GX");
        sb.append(TDateUtil.getCurrentDateByType("yyyyMMddHHmm"));
        sb.append(CodeUtil.getRandomNum(4));
        return sb.toString();
    }

    /**
     * 型号编号
     */
    public static String createDeviceModelNo() {
        return "DM" + CodeUtil.getRandomNum(8);
    }

    /**
     * 仓库编号
     */
    public static String createRepoNo() {
        return "RN" + CodeUtil.getRandomNum(8);
    }

    public static String uavOrderCode() {
        StringBuffer sb = new StringBuffer();
        sb.append("UD");
        sb.append(TDateUtil.getCurrentDateByType("yyyyMMddHHmmss"));
        sb.append(CodeUtil.getRandomNum(4));
        return sb.toString();
    }

    /**
     * 活动编号
     */
    public static String generateActivityNo() {
        return "AC" + CodeUtil.getRandomNum(5);
    }

}
