package com.mmc.oms.model.qo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/5/24 14:01
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "CouponQO对象", description = "Coupon查询QO")
public class CouponInfoQO extends BaseInfoQO implements Serializable {

    @ApiModelProperty(value = "优惠券状态 是否可领取 false否 true：是")
    private Boolean state;

    @ApiModelProperty(value = "优惠券id")
    private String couponId;

    @ApiModelProperty(value = "优惠券使用类型 1vip,2品牌券",required = true)
    private Integer useType;

    @ApiModelProperty(value = "优惠券名称")
    @Length(max = 64, message = "优惠券名称长度不能超过64个字符")
    private String couponName;


}

