package com.mmc.oms.model.dto.uav;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/9/23 15:05
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class UavOrderRemarkDTO implements Serializable {
    private static final long serialVersionUID = 2751635245494487278L;
    @ApiModelProperty(value = "评价id")
    private Integer id;
    @ApiModelProperty(value = "评价类型，0商城，1租赁")
    private Integer remarkType;
    @ApiModelProperty(value = "订单id")
    private Integer uavOrderId;
    @ApiModelProperty(value = "商品id")
    private Integer mallGoodsId;
    @ApiModelProperty(value = "评分")
    private Integer remarkLevel;
    @ApiModelProperty(value = "图片地址，‘，’隔开")
    private String uavImages;
    @ApiModelProperty(value = "评论内容")
    private String content;
    @ApiModelProperty(value = "生成时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;
}
