package com.mmc.oms.entity.order;

import com.mmc.oms.common.status.TranStatusDic;
import com.mmc.oms.common.util.CodeUtil;
import com.mmc.oms.model.dto.order.OrderInfoDTO;
import com.mmc.oms.model.vo.order.LeaseOrderVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small @Date 2023/5/26 15:46 @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OrderInfoDO implements Serializable {
    private static final long serialVersionUID = 6544149196885009444L;
    private Integer id;

    @ApiModelProperty(value = "订单编号")
    private String orderNo;

    @ApiModelProperty(value = "商品id")
    private Integer wareInfoId;

    @ApiModelProperty(value = "商品id")
    private String wareNo;

    @ApiModelProperty(value = "商品标题")
    private String wareTitle;

    @ApiModelProperty(value = "商品图片")
    private String wareImg;

    @ApiModelProperty(value = "套餐id")
    private Integer skuInfoId;

    @ApiModelProperty(value = "套餐名称")
    private String skuTitle;

    @ApiModelProperty(value = "购买用户id")
    private Integer repoAccountId;

    @ApiModelProperty(value = "购买用户uid")
    private String uid;

    @ApiModelProperty(value = "购买用户的名称")
    private String buyerName;

    @ApiModelProperty(value = "购买用户的手机号")
    private String buyerPhone;
    @ApiModelProperty(value = "购买用户的账号")
    private String accountNo;

    @ApiModelProperty(value = "用买用户单价 元/天")
    private BigDecimal unitPrice;

    @ApiModelProperty(value = "用买商品数量")
    private Integer wareNum;

    @ApiModelProperty(value = "应付金额")
    private BigDecimal shouldPay;

    @ApiModelProperty(value = "实付金额")
    private BigDecimal actualPay;

    @ApiModelProperty(value = "0 租赁 100 购买")
    private Integer orderType;

    @ApiModelProperty(value = "押金")
    private BigDecimal deposit;

    @ApiModelProperty(value = "租金总金额")
    private BigDecimal rentPrice;

    @ApiModelProperty(value = "租期开始日期")
    private Date startDate;

    @ApiModelProperty(value = "租期结束日期")
    private Date endDate;

    @ApiModelProperty(value = "付款天数")
    private Integer payDay;

    @ApiModelProperty(value = "交易订单状态 查订单状态字典")
    private String tranStatus;

    @ApiModelProperty(value = "减库方式")
    private Integer exWare;

    @ApiModelProperty(value = "用户备注")
    private String remark;

    @ApiModelProperty(value = "平台备注")
    private String pfRemark;

    @ApiModelProperty(value = "关闭原因")
    private String shutReason;

    @ApiModelProperty(value = "交易编号")
    private String payNo;

    @ApiModelProperty(value = "付款时间")
    private Date payTime;

    @ApiModelProperty(value = "发货时间")
    private Date sendWareTime;

    private Integer rcdCompanyId;
    private Date createTime;
    private Date updateTime;
    private Date returnTime;

    @ApiModelProperty(value = "优惠券id", example = "221")
    private Integer couponId;

    @ApiModelProperty(value = "规格id", example = "1")
    private Integer specsId;

    @ApiModelProperty(value = "余额", example = "4")
    private BigDecimal balance;

    @ApiModelProperty(value = "当前状态", example = "4")
    private String doing;
    @ApiModelProperty(value = "等待状态", example = "4")
    private String waiting;
    @ApiModelProperty(value = "导航栏等待状态", example = "4")
    private String leaseOrderStatus;
    @ApiModelProperty(value = "用户昵称")
    private String nickName;
    @ApiModelProperty(value = "商品描述")
    private String wareDescription;

    /**
     * 辅助字段
     *
     * @return
     */
    private OrderReceiptDO receipt;

    public OrderInfoDTO buildOrderInfoDTO() {
        return OrderInfoDTO.builder()
                .id(this.id)
                .orderNo(this.orderNo)
                .wareInfoId(this.wareInfoId)
                .wareNo(this.wareNo)
                .wareTitle(this.wareTitle)
                .skuInfoId(this.skuInfoId)
                .skuTitle(this.skuTitle)
                .repoAccountId(this.repoAccountId)
                .uid(this.uid)
                .buyerName(this.buyerName)
                .buyerPhone(this.buyerPhone)
                .unitPrice(this.unitPrice)
                .wareNum(this.wareNum)
                .shouldPay(this.shouldPay)
                .actualPay(this.actualPay)
                .orderType(this.orderType)
                .deposit(this.deposit)
                .rentPrice(this.rentPrice)
                .startDate(this.startDate)
                .endDate(this.endDate)
                .payDay(this.payDay)
                .tranStatus(this.tranStatus)
                .createTime(this.createTime)
                .payTime(this.payTime)
                .payNo(this.payNo)
                .wareImg(this.wareImg)
                .pfRemark(this.pfRemark)
                .shutReason(this.shutReason)
                .remark(this.remark)
                .receipt(this.receipt == null ? null : receipt.buildOrderReceiptDTO())
                .exWare(this.exWare)
                .sendWareTime(this.sendWareTime)
                .returnTime(this.returnTime)
                .couponId(this.couponId)
                .specsId(this.specsId)
                .balance(this.balance)
                .doing(this.doing)
                .waiting(this.waiting)
                .leaseOrderStatus(this.leaseOrderStatus)
                .nickName(this.nickName)
                .wareDescription(this.wareDescription)
                .build();
    }

    public OrderInfoDO(LeaseOrderVO lease) {
        this.orderNo = CodeUtil.createRepoOrderNo();
        this.wareInfoId = lease.getWareInfoId();
        this.wareNo = lease.getWareNo();
        this.wareTitle = lease.getWareTitle();
        this.wareImg = lease.getWareImg();
        this.skuInfoId = lease.getSkuInfoId();
        this.skuTitle = lease.getSkuTitle();
        this.repoAccountId = lease.getRepoAccountId();
        this.uid = lease.getUid();
        this.buyerName = lease.getBuyerName();
        this.buyerPhone = lease.getBuyerPhone();
        this.unitPrice = lease.getUnitPrice();
        this.wareNum = lease.getWareNum();
        this.shouldPay = lease.getShouldPay();
        this.actualPay = lease.getActualPay();
        this.orderType = lease.getOrderType();
        this.deposit = lease.getDeposit();
        this.rentPrice = lease.getRentPrice();
        this.startDate = lease.getStartDate();
        this.endDate = lease.getEndDate();
        this.payDay = lease.getPayDay();
        this.exWare = lease.getExWare();
        this.tranStatus = lease.getTranStatus();
        this.remark = lease.getRemark();
        this.createTime = lease.getCreateTime();
        this.rcdCompanyId = lease.getRcdCompanyId();
        this.returnTime = lease.getReturnDate();
        this.couponId = lease.getCouponId();
        this.specsId = lease.getSpecsId();
        this.tranStatus = TranStatusDic.INIT.getStatus();
        this.wareDescription = lease.getWareDescription();
    }
}
