package com.mmc.oms.entity.lease;

import com.mmc.oms.model.dto.lease.LeaseOrderDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * (LeaseOrderDO)实体类
 *
 * @author makejava
 * @since 2023-09-21 16:59:10
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LeaseOrderDO implements Serializable {
    private static final long serialVersionUID = -58305538180098964L;

    private Integer id;
    /**
     * 订单编号
     */
    private String orderNo;
    /**
     * 订单状态
     */
    private Integer statusCode;
    /**
     * 下单用户id
     */
    private Integer userAccountId;
    /**
     * 租赁商品id
     */
    private Integer leaseGoodsId;
    /**
     * 商家企业名称
     */
    private String companyName;
    /**
     * 商家id
     */
    private Integer thirdBackUserAccountId;
    /**
     * 商品标题
     */
    private String orderName;
    /**
     * sku图片/商品图片
     */
    private String skuImg;
    /**
     * 订单总金额
     */
    private BigDecimal orderTotalAmount;
    /**
     * 抵扣佣金金额
     */
    private BigDecimal salaryAmount;
    /**
     * 抵扣云享金金额
     */
    private BigDecimal shareAmount;
    /**
     * 其他渠道应支付金额
     */
    private BigDecimal otherAmount;
    /**
     * 支付方式，wechatpay微信，alipay支付宝，offline线下
     */
    private String payType;
    /**
     * 用户收货地址id
     */
    private Integer userAddressId;
    /**
     * 买家备注信息
     */
    private String userRemark;
    /**
     * 商家备注信息
     */
    private String sellerRemark;
    /**
     * 支付时间
     */
    private Date payTime;
    /**
     * 确认收货时间（成交时间）
     */
    private Date confirmReceiptTime;
    /**
     * 修改版本
     */
    private Integer version;
    /**
     * 评价状态
     */
    private Integer remarkStatus;
    /**
     * 订单分成比例（平台收取）
     */
    private Integer proportion;
    /**
     * 用户删除（0用户不可看，1用户可看）
     * （假删除，后台还能看到）
     */
    private Integer showUserPort;
    /**
     * 生成订单时间（下单时间）
     */
    private Date createTime;
    /**
     * 最近修改时间
     */
    private Date updateTime;
    /**
     * 单价 元/天
     */
    private BigDecimal unitPrice;
    /**
     * 购买的商品数量
     */
    private Integer wareNum;
    /**
     * 押金
     */
    private BigDecimal deposit;
    /**
     * 租约开始日
     */
    private Date startDate;
    /**
     * 租约结束日
     */
    private Date endDate;
    /**
     * 关闭原因
     */
    private String shutReason;
    /**
     * sku
     */
    private String sku;
    /**
     * 发货时间
     */
    private Date sendWareTime;

    public LeaseOrderDTO buildLeaseOrderDTO() {
        return LeaseOrderDTO.builder().id(id).orderNo(orderNo).statusCode(statusCode).userAccountId(userAccountId)
                .thirdBackUserAccountId(thirdBackUserAccountId).companyName(companyName).orderTotalAmount(orderTotalAmount)
                .salaryAmount(salaryAmount).shareAmount(shareAmount).otherAmount(otherAmount).payType(payType).payTime(payTime)
                .startDate(startDate).endDate(endDate).userRemark(userRemark).sellerRemark(sellerRemark).createTime(createTime)
                .confirmReceiptTime(confirmReceiptTime).remarkStatus(remarkStatus).sku(sku).skuImg(skuImg).build();
    }
}

