package com.mmc.oms.controller.lease;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.BaseController;
import com.mmc.oms.model.dto.lease.LeaseOrderDTO;
import com.mmc.oms.model.vo.lease.AddLeaseOrderVO;
import com.mmc.oms.service.lease.LeaseOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * @author: lw
 * @Date: 2023/9/21 16:29
 */
@Api(tags = {"最新版--租赁订单接口"})
@RestController
@RequestMapping("/lease/order/")
public class LeaseOrderController extends BaseController {

    @Resource
    private LeaseOrderService leaseOrderService;

    @ApiOperation(value = "提交订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LeaseOrderDTO.class)})
    @PostMapping("addLeaseOrder")
    public ResultBody<LeaseOrderDTO> addLeaseOrder(@RequestBody AddLeaseOrderVO param, HttpServletRequest request) {
        return leaseOrderService.addLeaseOrder(param, this.getCurrentAccount(request));
    }

}
