package com.mmc.oms.feign.hystrix;

import com.alibaba.fastjson2.JSONObject;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.feign.PmsAppApi;
import com.mmc.oms.model.dto.uav.UavCartDTO;
import com.mmc.oms.model.qo.uav.PriceStockQO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/6/5 15:19
 */
@Slf4j
public class PmsAppApiHystrix implements PmsAppApi {
    @Override
    public ResultBody feignLeaseGoodsInfoByAddressId(Integer id) {
        log.info("熔断：PmsAppApiHystrix.feignLeaseGoodsInfoByAddressId==error==>param:{}",id);
        return null;
    }

    @Override
    public List<UavCartDTO> listPriceStock(List<PriceStockQO> priceStockQOS) {
        log.info("熔断：PmsAppApiHystrix.listPriceStock==error==>param:{}", JSONObject.toJSONString(priceStockQOS));
        return null;
    }
}
