package com.mmc.oms.service.mall.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.mmc.oms.client.PmsClient;
import com.mmc.oms.client.UserClient;
import com.mmc.oms.common.*;
import com.mmc.oms.common.json.JsonUtil;
import com.mmc.oms.common.publicinterface.Publicsher;
import com.mmc.oms.common.result.PageResult;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.common.util.KdnExpressUtil;
import com.mmc.oms.common.util.TDateUtil;
import com.mmc.oms.dao.mall.AppMallOrderDao;
import com.mmc.oms.dao.mall.MallOrderDao;
import com.mmc.oms.entity.mall.*;
import com.mmc.oms.enums.OrderStatus;
import com.mmc.oms.enums.PayMethod;
import com.mmc.oms.enums.PayStatus;
import com.mmc.oms.enums.PayType;
import com.mmc.oms.model.dto.kdn.KdnExpDTO;
import com.mmc.oms.model.dto.mall.*;
import com.mmc.oms.model.dto.order.ExpStationsDTO;
import com.mmc.oms.model.dto.order.OrderCouponDTO;
import com.mmc.oms.model.dto.user.BaseAccountDTO;
import com.mmc.oms.model.dto.user.UserAccountSimpleDTO;
import com.mmc.oms.model.excel.*;
import com.mmc.oms.model.qo.mall.MallOrderQO;
import com.mmc.oms.model.vo.mall.*;
import com.mmc.oms.service.mall.*;
import com.mmc.oms.util.BeanCopyUtils;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author 作者 geDuo
 * @version 创建时间：2022年3月20日 下午9:40:44
 * @explain 类说明
 */
@Service
@Slf4j
public class MallOrderServiceImpl implements MallOrderService {

    @Autowired
    private MallOrderDao mallOrderDao;

    @Autowired
    private OrderExpressService orderExpressService;

    @Autowired
    private Publicsher publicsher;

    @Autowired
    private AppMallOrderDao appMallOrderDao;

//    @Autowired
//    private StringRedisService stringRedisService;

//    @Autowired
//    private FddServletClient fddServletClient;

//    @Autowired
//    private MallGoodsClient mallGoodsClient;

    @Autowired
    private OrderGoodsIndstService orderGoodsIndstService;

    @Autowired
    private OrderGoodsProdService orderGoodsProdService;
//
//    @Autowired
//    private UserAppApi userAppApi;
//
//    @Autowired
//    private PmsAppApi pmsAppApi;

    @Autowired
    private UserClient userClient;

    @Autowired
    private PmsClient pmsClient;

    /**
     * 检测提交的订单的商品信息在提交的过程中，后台是否有改动过商品数据（根据版本号判断）
     */
//    private ResultBody checkFormData(List<PlaceShopVO> places, List<ShopCarDTO> list) {
//        Map<Integer, Integer> mapPid = places.stream()
//                .collect(Collectors.toMap(PlaceShopVO::getShopCarId, PlaceShopVO::getPid, (k1, k2) -> k2));
//        for (ShopCarDTO d : list) {
//            Integer pid = mapPid.get(d.getId());
//            if (pid == null || !pid.equals(d.getPid())) {
//                return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
//            }
//        }
//        return ResultBody.success();
//    }

	/**
	 * 执行下单业务
	 */
//	@Transactional
//	public ResultBody placeOrder(List<ShopCarDTO> list, MallUserDTO muser, Integer userAddressId, Integer recMallUserId, Integer orderFlag, String remark) {
//		if (muser == null) {
//			return ResultBody.error(ResultEnum.MALL_USER_SERVLET_ERROR);
//		}
//		Date cdate = new Date();
//		MallOrderDO order = new MallOrderDO();
//		SnowFlake snowFlake = new SnowFlake(2, 3);
//		Long orderId = snowFlake.nextId();
//		order.setId(orderId);
//		order.setOrderNo(CodeUtil.uavOrderCode(order.getId()));
//		order.setPid(0);
//		order.setStatusCode(OrderStatus.PENDING_ASSIGNMENT.getCode());
//		order.setMallUserId(muser.getId());
//		order.setUid(muser.getUid());
//		order.setUserName(muser.getNickName());
//		order.setPhoneNum(muser.getPhoneNum());
//		order.setCreateTime(cdate);
//		order.setUserAddressId(userAddressId);
//		order.setRecMallUserId(recMallUserId==null?0:recMallUserId);
//		order.setOrderFlag(orderFlag);
//		order.setRemark((remark==null)?"":remark);
//		//暂时设为0
//		order.setOrderAmount(BigDecimal.ZERO);
//		mallOrderDao.insertMallOrder(order);
//
//        List<OrderGoodsDO> orderGoods = list.stream().map(d -> this.buildOrderGoodsDO(d, orderId, cdate)).collect(Collectors.toList());
//        mallOrderDao.batchInsertOrderGoods(orderGoods);
//
//        // 订单服务
//        List<OrderServiceDO> orderServices = this.buildAllOrderService(list, orderId);
//        if (!CollectionUtils.isEmpty(orderServices)) {
//            mallOrderDao.batchInsertOrderService(orderServices);
//        }
//
//        List<Integer> carIds = orderGoods.stream().map(OrderGoodsDO::getShopCarId).collect(Collectors.toList());
//        shopCarDao.batchUpdateShopCar(new UpdateShopCarDO(muser.getId(), remark, carIds));
//        MallOrderDTO morder = order.buildMallOrderDTO();
//        publicsher.sendInitMallOrder(morder);
//        return ResultBody.success(morder);
//    }

//    private List<OrderServiceDO> buildAllOrderService(List<ShopCarDTO> list, Long orderId) {
//        List<OrderServiceDO> orderServices = new ArrayList<OrderServiceDO>();
//        List<GoodsServiceDTO> services = new ArrayList<GoodsServiceDTO>();
//        for (ShopCarDTO d : list) {
//            if (!CollectionUtils.isEmpty(d.getServices())) {
//                services.addAll(d.getServices());
//            }
//        }
//        if (!CollectionUtils.isEmpty(services)) {
//            Date cdate = new Date();
//            orderServices = services.stream().map(d -> {
//                OrderServiceDO od = new OrderServiceDO(d, orderId);
//                od.setCreateTime(cdate);
//                return od;
//            }).collect(Collectors.toList());
//        }
//        return orderServices;
//    }

//    private OrderGoodsDO buildOrderGoodsDO(ShopCarDTO d, Long orderId, Date cdate) {
//        return OrderGoodsDO.builder().orderId(orderId).shopCarId(d.getId()).goodsInfoId(d.getGoodsInfoId())
//                .goodsNo(d.getGoodsNo()).goodsName(d.getGoodsName()).mainImg(d.getMainImg()).mallSkuId(d.getMallSkuId())
//                .skuTitle(d.getSkuTitle()).buyNum(d.getBuyNum()).createTime(cdate).build();
//    }

    /** 有可能不要 */
//    @Override
//    public PageResult listPage(Integer pageNo, Integer pageSize, String keyword, String orderType,
//                               BaseAccountDTO cuser) {
//        int count = mallOrderDao.countPageAmOrder(keyword, orderType, cuser.getUserAccountId());
//        if (count == 0) {
//            return PageResult.buildPage(pageNo, pageSize, count);
//        }
//        List<MallOrderDO> orders = mallOrderDao.listPageAmOrder((pageNo - 1) * pageSize, pageSize, keyword, orderType, cuser.getUserAccountId());
//        return PageResult.buildPage(pageNo, pageSize, count, this.buildMallOrderInfo(orders));
//    }
    /** 有可能不要 */
//    private List<MallOrderDTO> buildMallOrderInfo(List<MallOrderDO> orders) {
//        List<Long> orderIds = orders.stream().map(MallOrderDO::getId).collect(Collectors.toList());
//        List<OrderGoodsDTO> goods = mallOrderDao.listOrderGoods(orderIds).stream().map(d -> {
//            return d.buildOrderGoodsDTO();
//        }).collect(Collectors.toList());
//        Map<Long, List<OrderGoodsDTO>> mapGood = goods.stream()
//                .collect(Collectors.groupingBy(OrderGoodsDTO::getOrderId));
//        //匹配运营人员信息
//        List<Integer> opIds = orders.stream().distinct().map(MallOrderDO::getOperationId).collect(Collectors.toList());
//        opIds.removeIf(Objects::isNull);
//        opIds = opIds.stream().distinct().collect(Collectors.toList());
//        //List<UserAccountDTO> operateUser = userServletClient.feignListUserAccountById(UserAccountQO.builder().userIds(opIds).build());
//        List<UserAccountSimpleDTO> operateUserSimple = userAppApi.feignListUserAccountByIds(opIds, null);
//        Map<Integer, UserAccountSimpleDTO> mapOperate = CollectionUtils.isEmpty(operateUserSimple) ? null
//                : operateUserSimple.stream().collect(Collectors.toMap(UserAccountSimpleDTO::getId, user -> user, (k1, k2) -> k2));
//        for (MallOrderDO d : orders) {
//            if (mapOperate != null && mapOperate.containsKey(d.getOperationId())) {
//                d.setOperationName(mapOperate.get(d.getOperationId()).getUserName());
//            }
//        }
//        List<MallOrderDTO> data = orders.stream().map(d -> {
//            // 前端状态描述显示修改
//            if (d.getStatusCode().equals(OrderStatus.CONFIRM_ORDER.getCode())) {
//                if (d.getSignStatus() != null) {
//                    if (d.getSignStatus().equals(0) || d.getSignStatus().equals(1) || d.getSignStatus().equals(2) || d.getSignStatus().equals(3) || d.getSignStatus().equals(4)) {
//                        d.setStatusCode(d.getSignStatus());
//                    }
//                }
//            }
//            //MallUserDTO mallUserDTO = mallUserClient.feignGetSimpleUserInfo(d.getRecMallUserId());
//            UserAccountSimpleDTO userAccountSimpleDTO = userAppApi.feignGetUserSimpleInfo(d.getRecMallUserId(), null);
//            if (userAccountSimpleDTO != null) {
//                String UserName = userAccountSimpleDTO.getUid() + "" + (userAccountSimpleDTO.getUserName() == null ? "" : "(" + userAccountSimpleDTO.getUserName() + ")");
//                d.setRecMallUserName(UserName);
//            }
//            // 查询合同编号
//            ResultBody<List<UavContractInfoDTO>> resultBody = fddServletClient.selectList(new UavContractInfoQO() {{
//                setMallOrderId(d.getId());
//            }});
//            if (resultBody != null && !CollectionUtils.isEmpty(resultBody.getResult())) {
//                UavContractInfoDTO uavContractInfo = resultBody.getResult().get(0);
//                d.setContractNo((uavContractInfo != null) ? uavContractInfo.getContractNo() : "");
//                d.setSignStatus((uavContractInfo != null) ? uavContractInfo.getSignStatus() : null);
//            }
//            // 查询订单的收货信息
//            List<UserAddressDTO> result = mallUserClient.feignSelectList(new UserAddressQO() {{
//                setId(d.getUserAddressId());
//                setIsDeleteds(Arrays.asList(0, 1));
//            }}).getResult();
//            if (!CollectionUtils.isEmpty(result)) {
//                d.setUserAddress(result.get(0));
//            }
//            MallOrderDTO od = d.buildMallOrderDTO();
//            Collections.sort(mapGood.get(d.getId()), Comparator.comparing(OrderGoodsDTO::getBuyNum).reversed());
//            od.setGoods(mapGood.get(d.getId()));
//            return od;
//        }).collect(Collectors.toList());
//        return data;
//    }

//    @Override
//    public ResultBody confrimOrder(Long orderId, BaseAccountDTO cuser) {
//        MallOrderDO order = mallOrderDao.getMallOrderInfo(orderId);
//        ResultBody result = this.orderEvolution(order, OrderStatus.CONFIRM_ORDER.getCode());
//        if (!ResultBody.isSuccess(result)) {
//            return result;
//        }
//        return ResultBody.success();
//    }

    @Override
    public ResultBody orderPay(OrderPayVO param, BaseAccountDTO cuser) {
        if (param.getPayType().toString().equals(PayType.ALL_PAY.getCode().toString())
                || param.getPayType().toString().equals(PayType.AD_PAY.getCode().toString())) {
            return this.beforePay(param, cuser);// 首次-付款凭证(全款or预付款)
        }
//		else if (param.getPayType().toString().equals(PayType.AF_PAY.getCode().toString())) {
//			return this.supplementPay(param, cuser); // 补尾款
//		}
        return ResultBody.error(ResultEnum.ORDER_STATUS_ERROR);
    }

    /**
     * 首次-付款凭证(全款or预付款)
     *
     * @param param
     * @param cuser
     * @return
     */
    private ResultBody beforePay(OrderPayVO param, BaseAccountDTO cuser) {
        MallOrderDO order = mallOrderDao.getMallOrderInfo(param.getOrderId());
        Integer payMethod = param.getPayType() == 0 ? PayMethod.ALL.getCode() : PayMethod.DIVIDE.getCode();
        order.setPayMethod(payMethod);
        ResultBody result = this.orderEvolution(order, OrderStatus.ORDER_PAY.getCode());
        if (!ResultBody.isSuccess(result)) {
            return result;
        }
        this.updateOrerPayInfo(param, order, null);
        return ResultBody.success();
    }

    @Override
    public ResultBody afterPay(OrderPayVO param, BaseAccountDTO cuser) {
        if (param.getPayType().toString().equals(PayType.AF_PAY.getCode().toString())) {
            MallOrderDO order = mallOrderDao.getMallOrderInfo(param.getOrderId());
            return this.supplementPay(param, cuser, order); // 补尾款
        }
        if (param.getPayType().equals(PayType.CA_PAY.getCode())) {
            MallOrderDO order = mallOrderDao.getMallOrderInfo(param.getOrderId());
            return this.supplementPay(param, cuser, order); // 补验收
        }
        return ResultBody.error(ResultEnum.ORDER_STATUS_ERROR);
    }

    public ResultBody afterPay(OrderPayVO param, BaseAccountDTO cuser, String goTo) {
        if (param.getPayType().toString().equals(PayType.AF_PAY.getCode().toString())) {
            return this.supplementPay(param, cuser, goTo); // 补尾款
        }
        if (param.getPayType().toString().equals(PayType.CA_PAY.getCode().toString())) {
            return this.supplementPay(param, cuser, goTo); // 补验收
        }
        if (param.getPayType().toString().equals(PayType.ALL_PAY.getCode().toString())) { //全款
            ContinueToUpload(param);
        }
        if (param.getPayType().toString().equals(PayType.AD_PAY.getCode().toString())) { //预付款
            ContinueToUpload(param);
        }
        return ResultBody.error(ResultEnum.ORDER_STATUS_ERROR);
    }

    private void ContinueToUpload(OrderPayVO param) {
        OrderPayDO pay = mallOrderDao.getOrderPayInfo(param.getOrderId(), param.getPayType());
        OrderPayDO orderPayDO = new OrderPayDO();
        orderPayDO.setPayStatus(PayStatus.INIT.getCode());
        orderPayDO.setOrderId(param.getOrderId());
        orderPayDO.setPayRemark(param.getPayRemark());
        if (!CollectionUtils.isEmpty(param.getVouchr())) {
            List<String> vouchr = param.getVouchr();
            String str = "";
            if (pay.getVouchr() != null) {
                str = pay.getVouchr() + "," + String.join(",", vouchr);
            } else {
                str = String.join(",", vouchr);
            }
            orderPayDO.setVouchr(str);
        }
        mallOrderDao.updateOrderPay(orderPayDO);
    }

    /**
     * 支付尾款
     *
     * @return
     */
    private ResultBody supplementPay(OrderPayVO param, BaseAccountDTO cuser) {
        MallOrderDO order = mallOrderDao.getMallOrderInfo(param.getOrderId());

        ResultBody result = this.orderEvolution(order, OrderStatus.AFTER_PAY.getCode());
        if (!ResultBody.isSuccess(result)) {
            return result;
        }
        this.updateOrerPayInfo(param, order, param.getPayType());
        return ResultBody.success();
    }

    /**
     * 支付尾款
     *
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public ResultBody supplementPay(OrderPayVO param, BaseAccountDTO cuser, MallOrderDO order) {
        ResultBody result = this.orderEvolution(order, OrderStatus.AFTER_PAY.getCode());
        if (!ResultBody.isSuccess(result)) {
            return result;
        }
        this.updateOrerPayInfo(param, order, param.getPayType());
        return ResultBody.success();
    }

    /**
     * 继续上传支付尾款
     *
     * @return
     */
    private ResultBody supplementPay(OrderPayVO param, BaseAccountDTO cuser, String goTo) {
        MallOrderDO order = mallOrderDao.getMallOrderInfo(param.getOrderId());
        ResultBody result = null;
        if(param.getPayType().toString().equals(PayType.CA_PAY.getCode().toString())){
            //上传验收凭证后，订单完成-------->订单完成操作有确认收货完成
            //result = this.orderEvolution(order, OrderStatus.FINISH.getCode());
        }else {
            result = this.orderEvolution(order, OrderStatus.AFTER_PAY.getCode());
        }
        if (!ResultBody.isSuccess(result)) {
            return result;
        }
        if (StringUtils.isNotBlank(goTo) && !CollectionUtils.isEmpty(param.getVouchr())) {
            //查询原来的，拼接上
            OrderPayDO orderPayInfo = mallOrderDao.getOrderPayInfo(param.getOrderId(), param.getPayType());
            if (orderPayInfo != null && StringUtils.isNotBlank(orderPayInfo.getVouchr())) {
                String[] split = orderPayInfo.getVouchr().split(",");
                List<String> vouchr = param.getVouchr();
                for (String s : split) {
                    vouchr.add(s);
                }
            }
        }
        this.updateOrerPayInfo(param, order, param.getPayType());
        return ResultBody.success();
    }

    @Override
    public ResultBody confirmCost(Integer orderId, Integer checkStatus, String refuseReason, List<String> vouchr, Integer type, BaseAccountDTO cuser) {
        MallOrderDO order = mallOrderDao.getMallOrderInfo(orderId);
        Integer nextStatus;
        Integer payStatus;
        if (checkStatus == 1) {
            // 通过,商品准备中状态去掉
            //nextStatus = OrderStatus.CONFIRM_INVENTORY.getCode();
            //需要判断是全款、预付款
            if(type.equals(PayMethod.ALL.getCode())){
                nextStatus = OrderStatus.CONFIRM_INVENTORY.getCode();
                //发短信
                order.setStatusCode(nextStatus);
//                publicsher.sendInitMallOrder(order.buildMallOrderDTO());
            }else {
                nextStatus = OrderStatus.WAITING_FOR_AFTER_PAY.getCode();
            }
            payStatus = PayStatus.ACCESS.getCode();
        } else {
            // 拒绝
            nextStatus = OrderStatus.ERROR_PAY.getCode();
            payStatus = PayStatus.REFUSE.getCode();
        }
        ResultBody result = this.orderEvolution(order, nextStatus);
        if (!ResultBody.isSuccess(result)) {
            return result;
        }
        OrderPayDO orderPay = mallOrderDao.getOrderPayInfo(orderId, null);
        OrderPayDO upPay = new OrderPayDO();
        upPay.setId(orderPay.getId());
        upPay.setPayStatus(payStatus);
        upPay.setRefuseReason(refuseReason);
        upPay.setPayType(type);
        if (!CollectionUtils.isEmpty(vouchr)) {
            upPay.setVouchr(String.join(",", vouchr));
        }
        mallOrderDao.updateOrderPay(upPay);
        //发订单状态变更通知
        //this.sendOrderStatusChangeMsg(orderId);
        return ResultBody.success();
    }

    @Override
    public ResultBody confirmInventory(Integer orderId, BaseAccountDTO cuser) {
        MallOrderDO order = mallOrderDao.getMallOrderInfo(orderId);
        ResultBody result = this.orderEvolution(order, OrderStatus.CONFIRM_INVENTORY.getCode());
        if (!ResultBody.isSuccess(result)) {
            return result;
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody confirmReceipt(OrderPayVO param, BaseAccountDTO cuser) {
        MallOrderDO order = mallOrderDao.getMallOrderInfo(param.getOrderId());
        //直接完成订单
        ResultBody result = this.orderEvolution(order, OrderStatus.FINISH.getCode());
        if (!ResultBody.isSuccess(result)) {
            return result;
        }
//        //扣减冻结，使用优惠券后，discountAmount基本是0，不会走这里
//        if (order.getDiscountAmount().compareTo(BigDecimal.ZERO) > 0){
//            deductBonus(order,cuser);
//        }

        //记录签收时间
        MallOrderExpressVO orderExpressVO = new MallOrderExpressVO();
        orderExpressVO.setOrderId(order.getId());
        orderExpressVO.setReceiveTime(new Date());
        orderExpressVO.setReceive(1);
        orderExpressService.updateOrderExpress(orderExpressVO);
        return ResultBody.success();

//        if (order.getPayMethod().toString().equals(PayMethod.ALL.getCode().toString())) {
//            // 全款
//            ResultBody result = this.orderEvolution(order, OrderStatus.FINISH.getCode());
//            if (!ResultBody.isSuccess(result)) {
//                return result;
//            }
//
//            return ResultBody.success();
//        } else {
//            // 分期付款
//            ResultBody result = this.checkPayParam(param);
//            if (!ResultBody.isSuccess(result)) {
//                return result;
//            }
//            return this.supplementPay(param, cuser);// 上传尾款
//        }
    }

    private ResultBody checkPayParam(OrderPayVO param) {
        if (param.getPayType() == null) {
            return ResultBody.error(ResultEnum.PARAM_DEFECT);
        }
        if (CollectionUtils.isEmpty(param.getVouchr())) {
            return ResultBody.error(ResultEnum.PARAM_DEFECT);
        }
        return ResultBody.success();
    }

//	@Override
//	public ResultBody orderFinish(Long orderId, BaseAccountDTO cuser) {
//		MallOrderDO order = mallOrderDao.getMallOrderInfo(orderId);
//		ResultBody result = this.orderEvolution(order, OrderStatus.FINISH.getCode());
//		if (!ResultBody.isSuccess(result)) {
//			return result;
//		}
//		return ResultBody.success();
//	}

    /**
     * 订单状态进化
     *
     * @param order
     * @param
     * @return
     */
    private ResultBody orderEvolution(MallOrderDO order, Integer nextStatusCode) {
        String statusCode = nextStatusCode.toString();

        MallOrderDO upOrder = new MallOrderDO();
        upOrder.setId(order.getId());
        upOrder.setStatusCode(nextStatusCode);
        upOrder.setPid(order.getPid());
        upOrder.setShutReason(order.getShutReason());
        upOrder.setPayMethod(order.getPayMethod());
        int count = mallOrderDao.updateMallOrder(upOrder);
        if (count == 0) {
            return ResultBody.error(ResultEnum.DATA_VERSION_ERROR);
        }
        return ResultBody.success();

    }

    @Resource
    private RedisTemplate<String, MallStatusDTO> redisTemplate;

    @Override
    public List<MallStatusDTO> listOrderStatus() {
        List<MallStatusDTO> list = redisTemplate.opsForList().range(RedisConstant.UAV_MALL_ORDER_STATUS, 0, -1);
        if (CollectionUtils.isEmpty(list)) {
            list = mallOrderDao.listOrderStatus().stream().map(d -> d.buildMallOrderStatusDTO()).collect(Collectors.toList());
            list.add(2, new MallStatusDTO("待用户签署合同", 0, 2));
            list.add(3, new MallStatusDTO("用户签署失败", 1, 0));
            list.add(4, new MallStatusDTO("待平台签署合同", 2, 4));
            list.add(6, new MallStatusDTO("平台签署成功", 4, 200));
            redisTemplate.opsForList().leftPushAll(RedisConstant.UAV_MALL_ORDER_STATUS, list);
        }
        return list;
    }

    @Override
    public ResultBody closeOrder(Integer orderId, String shutReason, BaseAccountDTO cuser) {
        MallOrderDO order = mallOrderDao.getMallOrderInfo(orderId);
        StringBuffer stringBuffer = new StringBuffer();
        if (StringUtils.isEmpty(shutReason)){
            stringBuffer.append("用户取消");
        }else {
            stringBuffer.append("用户取消：" + shutReason);
        }
        order.setShutReason(stringBuffer.toString());
        ResultBody result = this.orderEvolution(order, OrderStatus.CLOSE.getCode());
        if (!ResultBody.isSuccess(result)) {
            return result;
        }
        //先注释优惠金退回230406
        //rollbackBonus(order,null);
        if (order.getDiscountAmount().compareTo(BigDecimal.ZERO) > 0){
            //如果优惠金金额大于0,说明使用了优惠金
            //rollbackBonus(order,null);
        }
        //对优惠券进行退回
        if (order.getCouponDiscountAmount().compareTo(BigDecimal.ZERO) > 0){
            rollbackCoupons(orderId);
        }
        return ResultBody.success();
    }
//
//    // 优惠金退回
//    private Integer rollbackBonus(MallOrderDO order, BaseAccountDTO cuser){
//        cuser = getBackgroundUser(cuser);
//        order = mallOrderDao.getMallOrderInfo(order.getId());
//        BigDecimal discountAmount = order.getDiscountAmount();
//        log.info("优惠金退回MallOrderDO==>[{}]", JSONObject.toJSONString(order));
//        if(discountAmount.compareTo(BigDecimal.ZERO)>0 && OrderStatus.CLOSE.getCode().equals(order.getStatusCode())) {
//            ChangeBonusVO changeBonusVO = new ChangeBonusVO();
//            String orderName = getOrderName(order.getId());
//            changeBonusVO.setOrderName(orderName);
//            changeBonusVO.setOrderTaskNo(order.getOrderNo());
//            changeBonusVO.setChangeAmount(order.getDiscountAmount());
//            changeBonusVO.setUserId(order.getMallUserId());
//            changeBonusVO.setUpdateUserId(cuser!=null?cuser.getId():null);
//            log.info("优惠金退回ChangeBonusVO==>[{}]", JSONObject.toJSONString(changeBonusVO));
//            return mallUserPayClient.rollbackBonusByUserId(changeBonusVO);
//        }
//        return 0;
//    }

//    // 优惠金扣除
//    private Integer deductBonus(MallOrderDO order, BaseAccountDTO cuser){
//        cuser = getBackgroundUser(cuser);
//        order = mallOrderDao.getMallOrderInfo(order.getId());
//        BigDecimal discountAmount = order.getDiscountAmount();
//        log.info("优惠金扣除OrderId[{}],状态[{}]",order.getId(),order.getStatusCode());
//        if(discountAmount.compareTo(BigDecimal.ZERO)>0 && OrderStatus.FINISH.getCode().equals(order.getStatusCode())) {
//            ChangeBonusVO changeBonusVO = new ChangeBonusVO();
//            String orderName = getOrderName(order.getId());
//            changeBonusVO.setOrderName(orderName);
//            changeBonusVO.setOrderTaskNo(order.getOrderNo());
//            changeBonusVO.setChangeAmount(order.getDiscountAmount());
//            changeBonusVO.setUserId(order.getMallUserId());
//            changeBonusVO.setUpdateUserId(cuser!=null?cuser.getId():null);
//            log.info("优惠金扣除的ChangeBonusVO[{}]", JSONObject.toJSONString(changeBonusVO));
//            return mallUserPayClient.deductBonusByUserId(changeBonusVO);
//        }
//        return 0;
//    }

    private String getOrderName(Integer orderId){
        // 获取订单名字
        String orderName = "";
        List<MallOrderSimpleDO> pMallOrderSimpleDOList = orderGoodsProdService.listOrderGoodsProdBaseInfo(Arrays.asList(orderId));
        List<MallOrderSimpleDO> iMallOrderSimpleDOList = orderGoodsIndstService.listOrderGoodsIndstBaseInfo(Arrays.asList(orderId));
        if (!CollectionUtils.isEmpty(pMallOrderSimpleDOList)) {
            orderName = pMallOrderSimpleDOList.get(0).getOrderGoodsCommonDOS().get(0).getGoodsName();
        }
        if (!CollectionUtils.isEmpty(iMallOrderSimpleDOList)) {
            orderName = iMallOrderSimpleDOList.get(0).getOrderGoodsCommonDOS().get(0).getGoodsName();
        }
        return orderName;
    }

//    @Override
//    public MallOrderDTO orderDetail(Long orderId, BaseAccountDTO cuser) {
//        MallOrderDO mallOrderInfo = mallOrderDao.getMallOrderInfo(orderId);
//        if (mallOrderInfo == null) {
//            return new MallOrderDTO();
//        }
//        MallOrderDTO order = mallOrderInfo.buildMallOrderDTO();
//        if (order.getOrderFlag().equals(0)) {
//            //处理标品订单的详情回显,standardOrder
//            standardOrder(orderId, mallOrderInfo, order, cuser);
//        }
//        if (order.getOrderFlag().equals(1)) {
//            //处理非标品订单的详情回显,standardOrder
//            unStandardOrder(orderId, mallOrderInfo, order, cuser);
//        }
//        // 查询合同编号
//        ResultBody<List<UavContractInfoDTO>> resultBody = fddServletClient.selectList(new UavContractInfoQO() {{
//            setMallOrderId(order.getId());
//        }});
//        if (resultBody != null && !CollectionUtils.isEmpty(resultBody.getResult())) {
//            UavContractInfoDTO uavContractInfo = resultBody.getResult().get(0);
//            order.setContractNo((uavContractInfo != null) ? uavContractInfo.getContractNo() : null);
//            order.setSignStatus((uavContractInfo != null) ? uavContractInfo.getSignStatus() : null);
//            order.setArchiveDate((uavContractInfo != null) ? uavContractInfo.getArchiveDate() : null);
//        }
//        return order;
//    }
//
//    private void unStandardOrder(Long orderId, MallOrderDO mallOrderInfo, MallOrderDTO order, BaseAccountDTO cuser) {
//        List<OrderGoodsDTO> orderGoods = mallOrderDao.listOrderGoodsInfo(orderId).stream().map(d -> {
//            return d.buildOrderGoodsDTO();
//        }).collect(Collectors.toList());
//        List<OrderGoodsDTO> goods = new ArrayList<>();
//        ResultBody<List<NonStandardizedGoodsDTO>> resultNonStandardizedGoods = mallGoodsClient.listNonStandardizedGoods(orderId);
//        if (resultNonStandardizedGoods != null && resultNonStandardizedGoods.getResult() != null) {
//            // 确认订单后，非标品的商品才显示
//            if (mallOrderInfo.getStatusCode() >= 200 && !CollectionUtils.isEmpty(resultNonStandardizedGoods.getResult())) {
//                List<NonStandardizedGoodsDTO> nonStandardizedGoodsDTOS = resultNonStandardizedGoods.getResult();
//                goods = nonStandardizedGoodsDTOS.stream().map(item -> {
//                    OrderGoodsDTO orderGoodsDTO = OrderGoodsDO.buildOrderGoodsDTO(item);
//                    orderGoodsDTO.setNonStandardizeGoodsId(item.getId());
//                    return orderGoodsDTO;
//                }).collect(Collectors.toList());
//            } else {
//                if (!CollectionUtils.isEmpty(orderGoods)) {
//                    goods.add(orderGoods.get(0));
//                }
//            }
//        }
//        // 查询商品备注
//        for (OrderGoodsDTO good : goods) {
//            ShopCarDO shopCarInfo = shopCarDao.getShopCarInfo(new ShopCarDO(good.getShopCarId()));
//            good.setRemark(shopCarInfo.getRemark());
//        }
//        order.setGoods(goods);
//        BigDecimal shopCarAmount = BigDecimal.ZERO;
//        for (OrderGoodsDTO good : goods) {
//            shopCarAmount = shopCarAmount.add(good.getGoodsAmount());
//        }
//        order.setShopCarAmount(shopCarAmount);
//        OrderExpressDO oexp = mallOrderDao.getOrderExpress(orderId);
//        if (oexp != null) {
//            OrderExpressDTO exp = oexp.buildOrderExpressDTO();
//            order.setExp(exp);
//            try {
//                order.setKdn(this.getOrderExpInfo(exp));// 获取物流动态信息
//            } catch (Exception e) {
//                throw new BizException("获取物流失败");
//            }
//        }
//        // 查询地址信息
//        UserAddressDTO userAddressDTO = mallUserClient.feignSelectList(new UserAddressQO() {{
//            setId(mallOrderInfo.getUserAddressId());
//            setIsDeleteds(Arrays.asList(0, 1));
//        }}).getResult().get(0);
//        order.setUserAddress(userAddressDTO);
//        order.setChannelClassId(mallUserClient.feignGetSimpleUserInfoByUUID(order.getUid()));
//        if (order.getChannelClassId() != null) {
//            TagInfoAllotVO tagInfo = stringRedisService.getTagInfo(order.getChannelClassId());
//            order.setChannelClassName(tagInfo.getTagName());
//        }
//    }
//
//    private void unStandardOrderVerOne(MallOrderDTO order, BaseAccountDTO cuser) {
//        List<OrderGoodsDTO> orderGoods = mallOrderDao.listOrderGoodsInfo(order.getId()).stream().map(d -> {
//            return d.buildOrderGoodsDTO();
//        }).collect(Collectors.toList());
//        List<OrderGoodsDTO> goods = new ArrayList<>();
//        ResultBody<List<NonStandardizedGoodsDTO>> resultNonStandardizedGoods = mallGoodsClient.listNonStandardizedGoods(order.getId());
//        if (resultNonStandardizedGoods != null && resultNonStandardizedGoods.getResult() != null) {
//            // 确认订单后，非标品的商品才显示
//            if (order.getStatusCode() >= 200 && !CollectionUtils.isEmpty(resultNonStandardizedGoods.getResult())) {
//                List<NonStandardizedGoodsDTO> nonStandardizedGoodsDTOS = resultNonStandardizedGoods.getResult();
//                goods = nonStandardizedGoodsDTOS.stream().map(item -> {
//                    OrderGoodsDTO orderGoodsDTO = OrderGoodsDO.buildOrderGoodsDTO(item);
//                    orderGoodsDTO.setNonStandardizeGoodsId(item.getId());
//                    return orderGoodsDTO;
//                }).collect(Collectors.toList());
//            } else {
//                if (!CollectionUtils.isEmpty(orderGoods)) {
//                    goods.add(orderGoods.get(0));
//                }
//            }
//        }
//        // 查询商品备注
//        for (OrderGoodsDTO good : goods) {
//            ShopCarDO shopCarInfo = shopCarDao.getShopCarInfo(new ShopCarDO(good.getShopCarId()));
//            good.setRemark(shopCarInfo.getRemark());
//        }
//        order.setGoods(goods);
//        BigDecimal shopCarAmount = BigDecimal.ZERO;
//        for (OrderGoodsDTO good : goods) {
//            shopCarAmount = shopCarAmount.add(good.getGoodsAmount());
//        }
//        order.setShopCarAmount(shopCarAmount);
//        OrderExpressDO oexp = mallOrderDao.getOrderExpress(order.getId());
//        if (oexp != null) {
//            OrderExpressDTO exp = oexp.buildOrderExpressDTO();
//            order.setExp(exp);
//            try {
//                order.setKdn(this.getOrderExpInfo(exp));// 获取物流动态信息
//            } catch (Exception e) {
//                throw new BizException("获取物流失败");
//            }
//        }
//        // 查询地址信息
//        UserAddressDTO userAddressDTO = mallUserClient.feignSelectList(new UserAddressQO() {{
//            setId(order.getUserAddressId());
//            setIsDeleteds(Arrays.asList(0, 1));
//        }}).getResult().get(0);
//        order.setUserAddress(userAddressDTO);
//        order.setChannelClassId(mallUserClient.feignGetSimpleUserInfoByUUID(order.getUid()));
//        if (order.getChannelClassId() != null) {
//            TagInfoAllotVO tagInfo = stringRedisService.getTagInfo(order.getChannelClassId());
//            order.setChannelClassName(tagInfo.getTagName());
//        }
//    }
//
//    private MallOrderDTO standardOrderVerOne(MallOrderDTO order, BaseAccountDTO cuser) {
//        // 查询行业订单表、产品订单表,获取对应的产品信息和产品规格
//        List<OrderGoodsVerOneDTO> orderGoods = getProductInfo(order.getId());
//
//        // 拼接商品服务
//        this.buildOrderGoodsServiceVerOne(orderGoods, order.getId());
//        Collections.sort(orderGoods, Comparator.comparing(OrderGoodsVerOneDTO::getBuyNum).reversed());
//        List<String> serviceNames = new ArrayList<>();
//        BigDecimal shopCarAmount = new BigDecimal("0");
//        // 对配套服务进行去重
//        for (OrderGoodsVerOneDTO good : orderGoods) {
//            shopCarAmount = shopCarAmount.add(good.getGoodsAmount() == null ? new BigDecimal("0") : good.getGoodsAmount());
//            if (good.getServices() == null) {
//                continue;
//            }
//            for (OrderServiceDTO service : good.getServices()) {
//                if (!serviceNames.contains(service.getServiceName())) {
//                    serviceNames.add(service.getServiceName());
//                }
//            }
//        }
//        order.setServiceNames(serviceNames);
//        order.setOrderGoods(orderGoods);
//        order.setShopCarAmount(shopCarAmount);
//        // 获取物流动态信息
//        OrderExpressDO oexp = mallOrderDao.getOrderExpress(order.getId());
//        if (oexp != null) {
//            OrderExpressDTO exp = oexp.buildOrderExpressDTO();
//            order.setExp(exp);
//            try {
//                order.setKdn(this.getOrderExpInfo(exp));
//            } catch (Exception e) {
//                throw new BizException("获取物流失败");
//            }
//        }
//        order.setChannelClassId(mallUserClient.feignGetSimpleUserInfoByUUID(order.getUid()));
//        if (order.getChannelClassId() != null) {
//            TagInfoAllotVO tagInfo = stringRedisService.getTagInfo(order.getChannelClassId());
//            order.setChannelClassName(tagInfo.getTagName());
//        }
//        return order;
//    }

//    private List<OrderGoodsVerOneDTO> getProductInfo(Long orderId) {
//        List<OrderGoodsVerOneDTO> orderGoods = new ArrayList<>();
//        // 查询行业订单表,获取对应的产品信息和产品规格
//        List<OrderGoodsIndstProdListBO> indstProdList = orderGoodsIndstService.getProductInfoByMallId(orderId);
//        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(indstProdList)) {
//            for (OrderGoodsIndstProdListBO indstProd : indstProdList) {
//                OrderGoodsVerOneDTO orderGoodsVerOne = OrderGoodsVerOneDTO.builder().orderId(orderId).goodsAmount(indstProd.getGoodsAmount()).
//                        goodsNo(indstProd.getGoodsNo()).mallIndstShopCarId(indstProd.getMallIndstShopCarId())
//                        .goodsInfoId(indstProd.getGoodsInfoId()).buyNum(indstProd.getBuyNum()).prodSkuSpecName(indstProd.getProdSkuSpecName())
//                        .prodSkuSpecImage(indstProd.getProdSkuSpecImage()).versionDesc(indstProd.getVersionDesc()).partNo(indstProd.getPartNo()).build();
//                orderGoods.add(orderGoodsVerOne);
//            }
//        }
//
//        // 查询产品订单表，获取对应的产品信息和产品规格
//        List<OrderGoodsProdDetailBO> prodList = orderGoodsProdService.getProductInfoByMallId(orderId);
//        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(prodList)) {
//            for (OrderGoodsProdDetailBO prod : prodList) {
//                OrderGoodsVerOneDTO orderGoodsVerOne = OrderGoodsVerOneDTO.builder().orderId(orderId).goodsAmount(prod.getGoodsAmount()).
//                        goodsNo(prod.getGoodsNo()).mallIndstShopCarId(prod.getMallProdShopCarDetailId())
//                        .goodsInfoId(prod.getGoodsInfoId()).buyNum(prod.getBuyNum()).prodSkuSpecName(prod.getProdSkuSpecName())
//                        .prodSkuSpecImage(prod.getProdSkuSpecImage()).versionDesc(prod.getVersionDesc()).partNo(prod.getPartNo()).build();
//                orderGoods.add(orderGoodsVerOne);
//            }
//        }
//        return orderGoods;
//    }


//    private void standardOrder(Long orderId, MallOrderDO mallOrderInfo, MallOrderDTO order, BaseAccountDTO cuser) {
//        List<OrderGoodsDTO> goods = mallOrderDao.listOrderGoodsInfo(orderId).stream().map(d -> {
//            return d.buildOrderGoodsDTO();
//        }).collect(Collectors.toList());
//
//        // 拼接商品服务
//        this.buildOrderGoodsService(goods, orderId);
//        Collections.sort(goods, Comparator.comparing(OrderGoodsDTO::getBuyNum).reversed());
//        List<String> serviceNames = new ArrayList<>();
//        BigDecimal shopCarAmount = new BigDecimal("0");
//        // 对配套服务进行去重
//        for (OrderGoodsDTO good : goods) {
//            shopCarAmount = shopCarAmount.add(good.getGoodsAmount() == null ? new BigDecimal("0") : good.getGoodsAmount());
//            if (good.getServices() == null) {
//                continue;
//            }
//            for (OrderServiceDTO service : good.getServices()) {
//                if (!serviceNames.contains(service.getServiceName())) {
//                    serviceNames.add(service.getServiceName());
//                }
//            }
//        }
//
//        // 查询商品备注
//        for (OrderGoodsDTO good : goods) {
//            ShopCarDO shopCarInfo = shopCarDao.getShopCarInfo(new ShopCarDO(good.getShopCarId()));
//            good.setRemark(shopCarInfo.getRemark());
//            good.setBookSpu(shopCarInfo.getBookSpu());
//        }
//        order.setServiceNames(serviceNames);
//        order.setGoods(goods);
//        order.setShopCarAmount(shopCarAmount);
//        OrderExpressDO oexp = mallOrderDao.getOrderExpress(orderId);
//        if (oexp != null) {
//            OrderExpressDTO exp = oexp.buildOrderExpressDTO();
//            order.setExp(exp);
//            try {
//                order.setKdn(this.getOrderExpInfo(exp));// 获取物流动态信息
//            } catch (Exception e) {
//                throw new BizException("获取物流失败");
//            }
//        }
//        // 查询地址信息
//        UserAddressDTO userAddressDTO = null;
//        Integer userAddressId = mallOrderInfo.getUserAddressId();
//        if (userAddressId != null && userAddressId != 0) {
//            userAddressDTO = mallUserClient.feignSelectList(new UserAddressQO() {{
//                setId(mallOrderInfo.getUserAddressId());
//                setIsDeleteds(Arrays.asList(0, 1));
//            }}).getResult().get(0);
//        }
//        order.setUserAddress(userAddressDTO);
//        order.setChannelClassId(mallUserClient.feignGetSimpleUserInfoByUUID(order.getUid()));
//        if (order.getChannelClassId() != null) {
//            TagInfoAllotVO tagInfo = stringRedisService.getTagInfo(order.getChannelClassId());
//            order.setChannelClassName(tagInfo.getTagName());
//        }
//    }


//    private void buildOrderGoodsService(List<OrderGoodsDTO> goods, Long orderId) {
//        List<OrderServiceDTO> services = mallOrderDao.listOrderService(orderId).stream().map(d -> {
//            return d.buildOrderServiceDTO();
//        }).collect(Collectors.toList());
//        if (!CollectionUtils.isEmpty(services)) {
//            Map<Integer, List<OrderServiceDTO>> mapService = services.stream()
//                    .collect(Collectors.groupingBy(OrderServiceDTO::getGoodsInfoId));
//            goods.forEach(d -> {
//                if (mapService.containsKey(d.getGoodsInfoId())) {
//                    d.setServices(mapService.get(d.getGoodsInfoId()));
//                }
//            });
//        }
//    }
//
//    private void buildOrderGoodsServiceVerOne(List<OrderGoodsVerOneDTO> goods, Long orderId) {
//        List<OrderServiceDTO> services = mallOrderDao.listOrderService(orderId).stream().map(d -> {
//            return d.buildOrderServiceDTO();
//        }).collect(Collectors.toList());
//        if (!CollectionUtils.isEmpty(services)) {
//            Map<Integer, List<OrderServiceDTO>> mapService = services.stream()
//                    .collect(Collectors.groupingBy(OrderServiceDTO::getGoodsInfoId));
//            goods.forEach(d -> {
//                if (mapService.containsKey(d.getGoodsInfoId())) {
//                    d.setServices(mapService.get(d.getGoodsInfoId()));
//                }
//            });
//        }
//    }

    /**
     * 获取物流动态信息
     *
     * @param exp
     * @return
     * @throws Exception
     */
    private KdnExpDTO getOrderExpInfo(MallOrderExpressDTO exp) throws Exception {
        String json = "";
        if ("SF".equals(exp.getSendExpCode())) {
            json = KdnExpressUtil.SF(exp.getTakePhone(), exp.getSendExpNo());
        } else if ("JD".equals(exp.getSendExpCode())) {
            json = KdnExpressUtil.JD("", exp.getSendExpNo());
        } else {
            json = KdnExpressUtil.others(exp.getSendExpCode(), exp.getSendExpNo());
        }
        KdnExpDTO kdn = JsonUtil.parseJsonToObj(json, KdnExpDTO.class);
        kdn.setLogisticCode(exp.getSendExpNo());
        if (!CollectionUtils.isEmpty(kdn.getTraces())) {
            Collections.sort(kdn.getTraces(), Comparator.comparing(ExpStationsDTO::getAcceptTime).reversed());// 升序
        }
        return kdn;
    }

//    @Override
//    public PageResult listPageManager(MallOrderQO param, BaseAccountDTO currentAccount) {
//        //不是管理员。都只能看自己相关的订单
//        if (currentAccount.getAdmin() != 1) {
//            param.setOperationId(currentAccount.getId());
//        }
//        List<Integer> statusCode = param.getStatusCode();
//        // 状态码转换
//        statusCodeConvert(param, statusCode);
//        int count = mallOrderDao.countPagePmOrder(param);
//        if (count == 0) {
//            return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
//        }
//        Integer pageNo = param.getPageNo();
//        param.buildCurrentPage();
//        List<MallOrderDO> list = mallOrderDao.listPagePmOrder(param);
//        //匹配运营人员信息
//        List<Integer> opIds = list.stream().distinct().map(MallOrderDO::getOperationId).collect(Collectors.toList());
//        opIds.removeIf(Objects::isNull);
//        opIds = opIds.stream().distinct().collect(Collectors.toList());
//        List<UserAccountDTO> operateUser = userServletClient.feignListUserAccountById(UserAccountQO.builder().userIds(opIds).build());
//        Map<Integer, UserAccountDTO> mapOperate = CollectionUtils.isEmpty(operateUser) ? null
//                : operateUser.stream().collect(Collectors.toMap(UserAccountDTO::getId, user -> user, (k1, k2) -> k2));
//        List<MallOrderDTO> mallOrderDTOList = this.buildMallOrderInfo(list);
//        mallOrderDTOList.forEach(d -> {
//            if (mapOperate != null && mapOperate.containsKey(d.getOperationId())) {
//                d.setOperationName(mapOperate.get(d.getOperationId()).getUserName());
//            }
//            List<String> serviceNames = new ArrayList<>();
//            List<OrderGoodsDTO> goods = mallOrderDao.listOrderGoodsInfo(d.getId()).stream().map(item -> {
//                return item.buildOrderGoodsDTO();
//            }).collect(Collectors.toList());
//            // 拼接商品服务
//            this.buildOrderGoodsService(goods, d.getId());
//            // 对配套服务进行去重
//            for (OrderGoodsDTO good : goods) {
//                if (good.getServices() == null) {
//                    continue;
//                }
//                for (OrderServiceDTO service : good.getServices()) {
//                    if (!serviceNames.contains(service.getServiceName())) {
//                        serviceNames.add(service.getServiceName());
//                    }
//                }
//            }
//            // 查询商品备注
//            List<OrderGoodsDTO> dGoods = d.getGoods();
//            if (!CollectionUtils.isEmpty(dGoods)) {
//                for (OrderGoodsDTO good : dGoods) {
//                    ShopCarDO shopCarInfo = shopCarDao.getShopCarInfo(new ShopCarDO(good.getShopCarId()));
//                    good.setRemark(shopCarInfo.getRemark());
//                }
//            }
//            d.setServiceNames(serviceNames);
//        });
//        return PageResult.buildPage(pageNo, param.getPageSize(), count, mallOrderDTOList);
//    }

    @Override
    public List<OrderPayDTO> listOrderPayInfo(Integer orderId, Integer payType, BaseAccountDTO cuser) {
        List<OrderPayDTO> list = mallOrderDao.listOrderPay(orderId, payType).stream().map(d -> {
            return d.buildOrderPayDTO();
        }).collect(Collectors.toList());
        return list;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResultBody confirmAfPay(Integer orderId, Integer checkStatus, String refuseReason, List<String> vouchr, Integer type, BaseAccountDTO cuser) {
        MallOrderDO order = mallOrderDao.getMallOrderInfo(orderId);
        Integer nextStatus;
        Integer payStatus;
        if (checkStatus == 1) {
            // 通过
            //nextStatus = OrderStatus.FINISH.getCode();
            // 尾款凭证通过
            nextStatus = OrderStatus.CONFIRM_INVENTORY.getCode();
            payStatus = PayStatus.ACCESS.getCode();
            //发短信通知PMC
            MallOrderDTO mallOrderDTO = order.buildMallOrderDTO();
            mallOrderDTO.setStatusCode(nextStatus);
//            publicsher.sendInitMallOrder(mallOrderDTO);
        } else {
            // 拒绝
            nextStatus = OrderStatus.REFUSE_AFTER_PAY.getCode();
            payStatus = PayStatus.REFUSE.getCode();
        }
        ResultBody result = this.orderEvolution(order, nextStatus);
        if (!ResultBody.isSuccess(result)) {
            return result;
        }
        //当使用了优惠金才需要抵扣，有了优惠券之后，不会走这里，只为了兼容未走完的订单230406
        if (order.getDiscountAmount().compareTo(BigDecimal.ZERO) > 0){
            //deductBonus(order,cuser);
        }
        OrderPayDO orderPay = mallOrderDao.getOrderPayInfo(orderId, type);
        if(orderPay!=null){
            OrderPayDO upPay = new OrderPayDO();
            upPay.setId(orderPay==null?null:orderPay.getId());
            upPay.setPayStatus(payStatus);
            upPay.setRefuseReason(refuseReason);
            upPay.setPayType(type);
            if (!CollectionUtils.isEmpty(vouchr)) {
                upPay.setVouchr(String.join(",", vouchr));
            }
            mallOrderDao.updateOrderPay(upPay);
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody orderPayFinish(OrderPayVO param, BaseAccountDTO cuser) {
        MallOrderDO order = mallOrderDao.getMallOrderInfo(param.getOrderId());
        ResultBody result = this.orderEvolution(order, OrderStatus.FINISH.getCode());
        if (!ResultBody.isSuccess(result)) {
            return result;
        }
        //当使用了优惠金才需要抵扣，有了优惠券之后，不会走这里，只为了兼容未走完的订单230406
        if (order.getDiscountAmount().compareTo(BigDecimal.ZERO) > 0){
            //deductBonus(order,cuser);
        }
        param.setPayType(PayType.AF_PAY.getCode());
        this.updateOrerPayInfo(param, order, PayType.AF_PAY.getCode());
//        param.setPayType(PayType.AF_PAY.getCode());
//        this.updateOrerPayInfo(param, order, PayType.AF_PAY.getCode());
        //验收单后订单完成
        param.setPayType(PayType.CA_PAY.getCode());
        this.updateOrerPayInfo(param, order, PayType.CA_PAY.getCode());
        return ResultBody.success();
    }

    private void updateOrerPayInfo(OrderPayVO param, MallOrderDO order, Integer repaetPayType) {
        OrderPayDO orderPay = new OrderPayDO(param, order.getUserAccountId());
        OrderPayDO exitPay = mallOrderDao.getOrderPayInfo(param.getOrderId(), repaetPayType);
        orderPay.setPayStatus(PayStatus.INIT.getCode());
        orderPay.setPayType(param.getPayType());
        orderPay.setPayRemark(param.getPayRemark());
        if (exitPay == null) {
            orderPay.setCreateTime(new Date());
            mallOrderDao.insertOrderPay(orderPay);
        } else {
            orderPay.setId(exitPay.getId());
            mallOrderDao.updateOrderPay(orderPay);
        }
    }

    @Override
    public int countMenuRedPoint(BaseAccountDTO cuser) {
//		List<Integer> list = new ArrayList<Integer>();
//		list.add(OrderStatus.PLACE_ORDER.getCode());
//		list.add(OrderStatus.CONFIRM_ORDER.getCode());
//		list.add(OrderStatus.ORDER_PAY.getCode());
//		list.add(OrderStatus.CONFIRM_COST.getCode());
//		list.add(OrderStatus.SEND_ORDER_GOODS.getCode());
//		list.add(OrderStatus.AFTER_PAY.getCode());
        return mallOrderDao.countPMOrderConfirm(OrderStatus.PLACE_ORDER.getCode());
    }

    private void statusCodeConvert(MallOrderQO param, List<Integer> statusCode) {
        param.setSignStatus(dealOrderStatus(param, statusCode));
    }

    private List dealOrderStatus(MallOrderQO param, List<Integer> statusCode) {
        List<Integer> signStatus = new ArrayList<>();
        if (!CollectionUtils.isEmpty(statusCode)) {
            if (statusCode.contains(200)) {
                signStatus.add(5);
            } else {
                boolean flag = false;
                for (Integer status : statusCode) {
                    if (status < 50) {
                        flag = true;
                        signStatus.add(status);
                    }
                }
                if (flag) {
                    statusCode.add(200);
                }
            }
        }
        return signStatus;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResultBody confirmOrderVerOne(ConfirmOrderVO confirmOrderVO, BaseAccountDTO currentAccount) {
        MallOrderVO mallOrderVO = confirmOrderVO.getMallOrderVO();
        if (mallOrderVO == null || mallOrderVO.getId() == null) {
            throw new BizException("订单id不能为空");
        }
        Integer mallOrderId = mallOrderVO.getId();
        MallOrderDO order = mallOrderDao.getMallOrderInfo(mallOrderId);
        ResultBody result = this.orderEvolution(order, OrderStatus.CONFIRM_ORDER.getCode());
        if (!ResultBody.isSuccess(result)) {
            return result;
        }
        Integer creditPeriodDays = mallOrderVO.getCreditPeriodDays();
        // 默认3天
        creditPeriodDays = (creditPeriodDays == null) ? 3 : creditPeriodDays;
        mallOrderVO.setCreditPeriodDays(creditPeriodDays);
        // 线下合同确认订单时填入订单期限，线上的话合同签署完成后填入订单期限
        if(mallOrderVO.getContractSignedWay().equals(0)){
            Date creditPeriod = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(creditPeriod);
            calendar.add(Calendar.DATE,creditPeriodDays);
            creditPeriod = calendar.getTime();
            mallOrderVO.setCreditPeriod(creditPeriod);
        }
        mallOrderDao.updateMallOrder(BeanCopyUtils.properties(mallOrderVO, new MallOrderDO()));
        //发订单状态变更通知
        //this.sendOrderStatusChangeMsg(mallOrderId);
        return ResultBody.success();
    }

    @Override
    public void sendOrderStatusChangeMsg(Integer mallOrderId) {
        /**
        MallOrderDO order = mallOrderDao.getMallOrderInfo(mallOrderId);
        MallUserDTO mallUserDTO = mallUserClient.feignGetSimpleUserInfo(order.getMallUserId());
        if (mallUserDTO == null || StringUtils.isBlank(mallUserDTO.getOpenId())) {
            return;
        }
        AppletMsgVO aMsg = new AppletMsgVO();
        aMsg.setTouser(mallUserDTO.getOpenId());
        aMsg.setTemplate_id(WxMsgTemplete.MALL_ORDER_STATUS_CHANGE);
        aMsg.setPage(WxMsgDataConfig.M_ORDER_STATUS_CHANGE_PAGE);

        // 商品名称
        JSONObject thing1 = new JSONObject();

        thing1.put("value", this.getOrderStatusChangeMsg(order.getStatusCode(), mallOrderId));

        // 下单时间
        JSONObject time2 = new JSONObject();
        time2.put("value", TDateUtil.getCurrentDateMidd());

        JSONObject data = new JSONObject();
        data.put("thing1", thing1);
        data.put("time2", time2);

        aMsg.setData(data);
        mallUserClient.asynSendUserAppletMsg(aMsg);
 */
    }


    private String getOrderStatusChangeMsg(Integer orderStatus, Long mallOrderId) {
        if (orderStatus.toString().equals(OrderStatus.CONFIRM_ORDER.getCode().toString())) {
//            //有两条
//            //根据是否有合同去判断
//            UavContractInfoQO uavContractInfoQO = new UavContractInfoQO();
//            uavContractInfoQO.setMallOrderId(mallOrderId);
//            ResultBody<List<UavContractInfoDTO>> listResultBody = fddServletClient.selectList(uavContractInfoQO);
//            List<UavContractInfoDTO> list = listResultBody.getResult();
//            if (CollectionUtils.isEmpty(list)) {
//                return "订单受理，请上传付款凭证";
//            }
//            if (list.get(0).getSignStatus().toString().equals("4")) {
//                return "合同完成，请付款并上传凭证";
//            }
            return "订单受理，请及时签署在线合同";
        } else if (orderStatus.toString().equals(OrderStatus.ERROR_PAY.getCode().toString())) {
            //付款完成
            return "付款凭证审核未通过，请重新上传";
        } else if (orderStatus.toString().equals(OrderStatus.CONFIRM_INVENTORY.getCode().toString())) {
            //付款完成
            return "付款已确认，商品待发货";
        } else if (orderStatus.toString().equals(OrderStatus.SEND_ORDER_GOODS.getCode().toString())) {
            //配送中
            return "商品发货，请关注物流信息";
        }
        return "订单状态有变化，请关注订单信息";
    }

    @Override
    public ResultBody closeMallOrder(Integer id, BaseAccountDTO accountDTO) {
//        MallOrderDO beforeMallOrderDO = new MallOrderDO();
//        beforeMallOrderDO.setId(id);
//        beforeMallOrderDO.setStatusCode(OrderStatus.CLOSE.getCode());
//        beforeMallOrderDO.setShutReason("运营取消");
//        mallOrderDao.updateMallOrder(beforeMallOrderDO);
//        MallOrderDO mallOrderDO = mallOrderDao.getMallOrderInfo(id);
//        // 后台优惠金退回，需要注释230406
//        //如果discountAmount大于0，说明使用了优惠金
//        if (mallOrderDO.getDiscountAmount().compareTo(BigDecimal.ZERO) > 0){
//            rollbackBonus(mallOrderDO,accountDTO);
//        }
//        //需要对使用的优惠券进行回退
//        if (mallOrderDO.getCouponDiscountAmount().compareTo(BigDecimal.ZERO) > 0){
//            rollbackCoupons(id);
//        }
        return ResultBody.success();
    }

    private void rollbackCoupons(Integer id) {
        List<OrderCouponDO> orderCouponDOS = appMallOrderDao.listOrderCoupon(id);
        List<OrderCouponDTO> collect = orderCouponDOS.stream().map(d -> d.buildOrderCouponDTO()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)){
            log.info("订单优惠券回滚：{}---->rollbackCoupons", id);
//            Boolean res = mallUserPayClient.feignRollbackCoupons(collect);
        }
    }

    @Override
    public ResultBody updateMallOrder(Integer orderId, Date singerTime) {
//        MallOrderDO mallOrderInfo = mallOrderDao.getMallOrderInfo(orderId);
//        UavContractInfoDTO uavContractInfoDTO = fddServletClient.selectList(new UavContractInfoQO() {{
//            setMallOrderId(orderId);
//        }}).getResult().get(0);
//        Date date = DateUtils.toDate(DateUtils.toLocalDateTime(uavContractInfoDTO.getSingerTime()).plusDays(mallOrderInfo.getCreditPeriodDays()));
//        Integer count = mallOrderDao.updateMallOrder(new MallOrderDO() {{
//            setId(orderId);
//            setCreditPeriod(date);
//        }});
//        return ResultBody.success(count);
        return ResultBody.success();
    }

    @Override
    public ResultBody allocateOperation(Integer order, Integer operationId) {
        MallOrderDO mallOrderInfo = mallOrderDao.getMallOrderInfo(order);
        if (!mallOrderInfo.getStatusCode().equals(OrderStatus.PENDING_ASSIGNMENT.getCode())) {
            return ResultBody.error(ResultEnum.ORDER_STATUS_ERROR);
        }
        // 新增order的运营
        MallOrderDO mallOrderDO = new MallOrderDO();
        mallOrderDO.setOperationId(operationId);
        mallOrderDO.setId(order);
        mallOrderDO.setStatusCode(OrderStatus.PLACE_ORDER.getCode());
        mallOrderDao.updateMallOrder(mallOrderDO);
        // 修改订单状态
        //发短信通知
        mallOrderDO.setOrderNo(mallOrderInfo.getOrderNo());
        //publicsher.sendInitMallOrder(mallOrderDO.buildMallOrderDTO());
        return ResultBody.success();
    }

    @Override
    public ResultBody afterPayAndCheck(List<OrderPayVO> param, BaseAccountDTO currentAccount) {
        if (CollectionUtils.isEmpty(param)) {
            throw new BizException("参数不能为空");
        }
        for (OrderPayVO orderPayVO : param) {
            this.afterPay(orderPayVO, currentAccount);
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody continuePayAndCheck(List<OrderPayVO> param, BaseAccountDTO currentAccount) {
        if (CollectionUtils.isEmpty(param)) {
            throw new BizException("参数不能为空");
        }
        for (OrderPayVO orderPayVO : param) {
            this.afterPay(orderPayVO, currentAccount, "继续上传");
        }
        return ResultBody.success();
    }

    @Override
    public void confirmAfPayVerOne(ConfirmAfPayVO confirmPay, BaseAccountDTO currentAccount) {
        this.confirmAfPay(confirmPay.getOrderId(), confirmPay.getCheckStatus(), confirmPay.getRefuseReason(), confirmPay.getVouchr(), confirmPay.getPayType(), currentAccount);
    }

    @Override
    public ResultBody confirmCostVerOne(ConfirmAfPayVO confirmPay, BaseAccountDTO currentAccount) {
        this.confirmCost(confirmPay.getOrderId(), confirmPay.getCheckStatus(), confirmPay.getRefuseReason(), confirmPay.getVouchr(), confirmPay.getPayType(), currentAccount);
        return ResultBody.success();
    }

    @Override
    public ResultBody updateStatusMallOrder(Integer orderId, Integer signStatus) {
        Integer count = mallOrderDao.updateMallOrder(new MallOrderDO() {{
            setId(orderId);
            setSignStatus(signStatus);
        }});
        return ResultBody.success(count);
    }

    @Override
    public void mallOrderCreditPeriodTask() {
        log.info("======开始查询合同签署后的付款期限，逾期未打款合同作废======");
//        ResultBody<List<UavContractInfoDTO>> resultBody = fddServletClient.selectList(new UavContractInfoQO(5));
        ResultBody<List<UavContractInfoDTO>> resultBody = null;
        if (resultBody == null) {
            return;
        }
        List<UavContractInfoDTO> result = resultBody.getResult();
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(result)) {
            log.info("当前没有任何订单完成合同签署");
            return;
        }
        List<Integer> mallOrderIds = new ArrayList<>();
        for (UavContractInfoDTO uavContractInfoDTO : result) {
            Integer mallOrderId = uavContractInfoDTO.getMallOrderId();
            Date singerTime = uavContractInfoDTO.getSingerTime();
            if (singerTime == null) {
                log.info("签署时间不能为空,其订单id[{}]", mallOrderId);
                continue;
            }
            mallOrderIds.add(mallOrderId);
        }
        log.info("========查询线下签约的订单========");
        List<MallOrderDO> mallOrderDOS = mallOrderDao.getMallOrderByStatus(OrderStatus.CONFIRM_ORDER.getCode());
        if(!CollectionUtils.isEmpty(mallOrderDOS)) {
            for (MallOrderDO mallOrderDO : mallOrderDOS) {
                mallOrderIds.add(mallOrderDO.getId());
            }
        }
        if(CollectionUtils.isEmpty(mallOrderIds)){
            return;
        }
        Collections.sort(mallOrderIds);
        List<List<Integer>> partition = Lists.partition(mallOrderIds, 500);
        for (List<Integer> orderIds : partition) {
            List<MallOrderDO> mallOrderDOs = mallOrderDao.getMallOrderCreditPeriod(orderIds);
            for (MallOrderDO mallOrderDO : mallOrderDOs) {
                Integer mallOrderId = mallOrderDO.getId();
                Date creditPeriod = mallOrderDO.getCreditPeriod();
                if (mallOrderDO != null && creditPeriod != null) {
                    Integer statusCode = mallOrderDO.getStatusCode();
                    log.info("判断期限是否要进行合同做废,其参数为订单id[{}],付款期限[{}],订单状态[{}]", mallOrderId, creditPeriod, statusCode);
                    if (!statusCode.equals(OrderStatus.ORDER_PAY.getCode()) && statusCode <= OrderStatus.ERROR_PAY.getCode()) {
                        if (creditPeriod.before(new Date())) {
                            log.info("对合同进行做废,其订单id[{}]", mallOrderId);

                            // 封装参数,记录日志
                            Map<String, Object> paramMap = new HashMap<>();
                            paramMap.put("mallOrderId", mallOrderId);
                            paramMap.put("creditPeriod", creditPeriod);
                            paramMap.put("statusCode", statusCode);
                            ScheduleLogDO scheduleLogDO = new ScheduleLogDO();
                            scheduleLogDO.setScheduleName("逾期未打款合同作废");
                            scheduleLogDO.setParam(JSONObject.toJSONString(paramMap));
                            scheduleLogDO.setCreateTime(new Date());
                            scheduleLogDO.setCode(ResultEnum.SUCCESS.getResultCode());
                            scheduleLogDO.setResultDesc(ResultEnum.SUCCESS.getResultMsg());
                            //scheduleLogService.insert(scheduleLogDO);
                            BaseAccountDTO baseAccountDTO = new BaseAccountDTO();
                            this.closeMallOrder(mallOrderId,baseAccountDTO);
                        }
                    }
                }
            }
        }
        log.info("======查询合同签署的付款期限结束======");
    }

    @Override
    public PageResult listPageManagerVerOne(MallOrderQO param, BaseAccountDTO currentAccount, String token) {
//        List<Integer> statusCodes = this.getOrderStatusByShowType(param.getShowType());
//        param.setStatusCode(statusCodes);
        //不是管理员。都只能看自己相关的订单
//        if (currentAccount.getAdmin() != 1 && currentAccount.getPmc() != 1) {
//            param.setOperationId(currentAccount.getId());
//        }

        List<Integer> statusCode = param.getStatusCode();
//        // 状态码转换
        statusCodeConvert(param, statusCode);
        int count = mallOrderDao.countPagePmOrderVerOne(param);
        if (count == 0) {
            return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<MallOrderDO> list = mallOrderDao.listPagePmOrderVerOne(param);
        //转换查出来的订单信息
        List<MallOrderPageDTO> mallOrderPageDTOList = this.buildMallOrderPageDTO(list, token);
        return PageResult.buildPage(pageNo, param.getPageSize(), count, mallOrderPageDTOList);
    }

    public List<Integer> getOrderStatusByShowType(Integer showType){
        List<Integer> statusCodes = new ArrayList<>();
        if (showType == null){
            return null;
        }
        if(showType.equals(0)){
            statusCodes.add(50);
            statusCodes.add(100);
        } else if (showType.equals(1)) {
            statusCodes.add(200);
            statusCodes.add(300);
            statusCodes.add(350);
            statusCodes.add(650);
            statusCodes.add(660);
            statusCodes.add(670);
        } else if (showType.equals(2)) {
            statusCodes.add(710);
        } else if (showType.equals(3)) {
            statusCodes.add(720);
        } else if (showType.equals(4)) {
            statusCodes.add(800);
        } else if (showType.equals(5)) {
            statusCodes.add(999);
        }

        return statusCodes;
    }

    @Override
    public List<MallOrderPageDTO> buildMallOrderPageDTO(List<MallOrderDO> list, String token) {
        //1查出相关商品信息、2查出运营人员、3查出合同信息、4查出推荐人信息、5查出、6设置订单产品清单
        List<Integer> mallOrderIds = list.stream().map(MallOrderDO::getId).collect(Collectors.toList());
        //List<Integer> mallUserIds = list.stream().map(MallOrderDO::getMallUserId).collect(Collectors.toList());
        List<Integer> rcdMallUserIds = list.stream().map(MallOrderDO::getRecMallUserId).collect(Collectors.toList());
        //批量查出所有商品信息，有产品和行业两种商品订单信息，分别查出
        List<MallOrderSimpleDO> pMallOrderSimpleDOList = orderGoodsProdService.listOrderGoodsProdBaseInfo(mallOrderIds);
        //List<MallOrderSimpleDO> iMallOrderSimpleDOList = orderGoodsIndstService.listOrderGoodsIndstBaseInfo(mallOrderIds);

        // 获取下单用户的认证企业信
        List<Integer> userIds = list.stream().map(MallOrderDO::getUserAccountId).collect(Collectors.toList());
        //List<MallUserDTO> mallUserDTO = mallUserClient.feignListMallUserDTO(userIds);
        //List<UserAccountSimpleDTO> userAccountSimpleDTOS = userClient.feignListUserAccountByIds(userIds, token);

        // 获取推荐人信息
        //Map<Integer, MallUserDTO> integerMallUserDTOMap = mallUserPayClient.feignGetReferralInfos(userIds);

        List<UserAccountSimpleDTO> listRcdUserInfo = userClient.feignListRcdUserInfo(userIds, token);
        List<CooperationTagVO> cooperationTagVOList = userClient.feignListCooperationTag();
        // 获取用户的等级标签信息
//        List<MallUserDTO> newMallUserDTO = mallUserDTO.stream().peek(d->{
//            TagInfoDTO tagInfoDTO = systemServletClient.feignTagInfoById(d.getChannelClass());
//            if (tagInfoDTO != null) {
//                d.setTagName(tagInfoDTO.getTagName());
//            }
//        }).collect(Collectors.toList());



        List<MallOrderSimpleDO> commonMallOrderList = new ArrayList<>();
        commonMallOrderList.addAll(pMallOrderSimpleDOList);
        //commonMallOrderList.addAll(iMallOrderSimpleDOList);

        List<Integer> opIds = list.stream().distinct().map(MallOrderDO::getOperationId).collect(Collectors.toList());
        opIds.removeIf(Objects::isNull);
        opIds = opIds.stream().distinct().collect(Collectors.toList());
        //批量查出运营人员信息
        //List<UserAccountDTO> operateUser = userServletClient.feignListUserAccountById(UserAccountQO.builder().userIds(opIds).build());
        List<UserAccountSimpleDTO> operateUser = new ArrayList<>();
        //Map<Integer, UserAccountDTO> mapOperate = new HashMap<>();
        Map<Integer, UserAccountSimpleDTO> mapOperate = new HashMap<>();
        if( !CollectionUtils.isEmpty(opIds) ){
            operateUser = userClient.feignListUserAccountByIds(opIds, token );
            //生成key为运营人员id，value为运营人员信息的map
            mapOperate = CollectionUtils.isEmpty(operateUser) ? null
                    : operateUser.stream().collect(Collectors.toMap(UserAccountSimpleDTO::getId, user -> user, (k1, k2) -> k2));
        }
        //批量查出合同信息
        //List<UavContractInfoDTO> uavContractInfoDTOS = fddServletClient.feignListUAVContractByOIds(mallOrderIds);
        //批量查出买家信息
        //List<MallUserDTO> mallUserDTOList = mallUserClient.feignListMallUserDTO(mallUserIds);
        //批量查出推荐人信息
        //List<MallUserDTO> rcdMallUserDTOList = mallUserClient.feignListMallUserDTO(rcdMallUserIds);

        List<UserAccountSimpleDTO> rcdMallUserDTOList = userClient.feignListUserAccountByIds(rcdMallUserIds, token);

        Map<Integer, UserAccountSimpleDTO> finalMapOperate = mapOperate;
        List<MallOrderPageDTO> mallOrderPageDTOList = list.stream().map(d -> {
            MallOrderPageDTO mallOrderPageDTO = d.buildMallOrderPageDTO();
            //初始化订单商品数量为0
            mallOrderPageDTO.setTotalBuyNum(0);
            //设置订单商品信息
            for (MallOrderSimpleDO mallOrderSimpleDO : commonMallOrderList){
                if (mallOrderPageDTO.getId().equals(mallOrderSimpleDO.getId())){
                    //拿第一个商品信息来设置订单图片和订单名称
                    if(mallOrderPageDTO.getOrderName() == null && mallOrderPageDTO.getOrderMainImg()== null){
                        OrderGoodsCommonDO orderGoodsCommonDO = mallOrderSimpleDO.getOrderGoodsCommonDOS().get(0);
                        mallOrderPageDTO.setOrderMainImg(orderGoodsCommonDO.getMainImg());
                        mallOrderPageDTO.setOrderName(orderGoodsCommonDO.getGoodsName());
                    }
                    //设置订单商品总数
                    for (OrderGoodsCommonDO orderGoodsCommonDO : mallOrderSimpleDO.getOrderGoodsCommonDOS()){
                        mallOrderPageDTO.setTotalBuyNum(mallOrderPageDTO.getTotalBuyNum() + orderGoodsCommonDO.getBuyNum());
                    }
                }
            }
            //设置订单运营人员信息
            if (finalMapOperate != null && finalMapOperate.containsKey(d.getOperationId())) {
                mallOrderPageDTO.setOperationId(finalMapOperate.get(mallOrderPageDTO.getOperationId()).getId());
                mallOrderPageDTO.setOperationName(finalMapOperate.get(mallOrderPageDTO.getOperationId()).getUserName());
            }
            //设置合同信息
//            if (!CollectionUtils.isEmpty(uavContractInfoDTOS)) {
//                for (UavContractInfoDTO uavContractInfoDTO : uavContractInfoDTOS) {
//                    if (mallOrderPageDTO.getId().equals(uavContractInfoDTO.getMallOrderId())) {
//                        mallOrderPageDTO.setContractNo(uavContractInfoDTO.getContractNo());
//                        mallOrderPageDTO.setSignStatus(uavContractInfoDTO.getSignStatus());
//                        break;
//                    }
//                }
//            }

            if(CollectionUtil.isNotEmpty(rcdMallUserDTOList)){
                //设置推荐人信息
                for (UserAccountSimpleDTO rcdMallUserDTO : rcdMallUserDTOList){
                    if(rcdMallUserDTO.getId().toString().equals(d.getRecMallUserId().toString())){
                        mallOrderPageDTO.setRecMallUserName(rcdMallUserDTO.getUserName());
                        break;
                    }
                }
            }

            // 设置推荐人信息
//            if (integerMallUserDTOMap!=null && integerMallUserDTOMap.size() > 0) {
//                MallUserDTO upReferralInfo = integerMallUserDTOMap.get(d.getMallUserId());
//                if (upReferralInfo != null) {
//                    mallOrderPageDTO.setRecMallUserName(upReferralInfo.getUserName());
//                }
//            }

            // 设置下单用户认证企业信息
//            for (MallUserDTO userDTO : newMallUserDTO) {
//                if (d.getMallUserId().equals(userDTO.getId())){
//                    mallOrderPageDTO.setEntName(userDTO.getEntName());
//                    mallOrderPageDTO.setTagName(userDTO.getTagName());
//                    mallOrderPageDTO.setRealNameAuth(userDTO.getEntVerifyStatus());
//                    break;
//                }
//            }
            //6订单清单，产品和行业的，暂时这么做了-_-
            List<MallOrderProdListDTO> mallOrderProdListDTOList = this.getMallOrderProdListDTOList(d.getId());
            mallOrderPageDTO.setMallOrderProdListDTOList(mallOrderProdListDTOList);
            return mallOrderPageDTO;
        }).collect(Collectors.toList());

        return mallOrderPageDTOList;
    }

    @SneakyThrows
    @Override
    public void listPageManagerExportVerOne(MallOrderQO param, HttpServletResponse response, BaseAccountDTO currentAccount, String token) {
        //不是管理员。都只能看自己相关的订单
//        if (currentAccount.getAdmin() != 1) {
//            param.setOperationId(currentAccount.getId());
//        }
        List<Integer> statusCode = param.getStatusCode();
        // 状态码转换
        statusCodeConvert(param, statusCode);

        int count = mallOrderDao.countPagePmOrderVerOne(param);
        if (count == 0) {
            throw new BizException("没有需要导出的数据");
        }
        List<MallOrderDO> list = mallOrderDao.listExportOrderVerOne(param);

        List<MallOrderPageDTO> mallOrderPageDTOList = this.buildMallOrderPageDTO(list, token);
        OrderStatus[] values = OrderStatus.values();
        List<MallOrderExcel> collect = mallOrderPageDTOList.stream().map(d -> {
            MallOrderExcel mallOrderExcel = new MallOrderExcel(d);
            mallOrderExcel.setUserName(d.getUserName() == null ? "" : "(" + d.getUserName() + ")" + d.getUid());
            // 状态码转状态名
            for (OrderStatus orderStatus : values) {
                if (orderStatus.getCode().equals(d.getStatusCode())) {
                    mallOrderExcel.setStatusName(orderStatus.getName());
                    break;
                }
            }
            return mallOrderExcel;
        }).collect(Collectors.toList());
        Collection<MallOrderExcel> coll = collect;
        Workbook workbook = ExcelExportUtil.exportExcel(new ExportParams("无人机城订单", "订单列表"), MallOrderExcel.class, coll);
        String fileName = "订单数据" + TDateUtil.getCurrentDate();
        fileName = URLEncoder.encode(fileName, "UTF8");
        response.setContentType("application/vnd.ms-excel;chartset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xls");
        ServletOutputStream out = response.getOutputStream();
        workbook.write(out);
        out.flush();
        out.close();
    }

    @Override
    public MallOrderDTO getMallOrderDetailById(Integer orderId, BaseAccountDTO currentAccount, String token) {
        //1订单基本信息；2订单清单；3收货地址；4物流信息；5合同信息；6订单标题；7订单包含商品的数量；8订单服务；9订单状态转换；10渠道信息；11设置订单购买的规格信息；12查询使用的优惠券
        //1订单基本信息
        MallOrderDO mallOrderInfo = mallOrderDao.getMallOrderInfo(orderId);
        MallOrderDTO mallOrderDTO = mallOrderInfo.buildMallOrderDTO();
        //2订单清单，产品和行业的
        List<MallOrderProdListDTO> mallOrderProdListDTOList = this.getMallOrderProdListDTOList(orderId);
        mallOrderDTO.setMallOrderProdListDTOList(mallOrderProdListDTOList);
        // 3、4获取收货地址和物流动态信息
        MallOrderExpressDO oexp = mallOrderDao.getOrderExpress(orderId);
        if (oexp != null) {
            MallOrderExpressDTO exp = oexp.buildOrderExpressDTO();
            mallOrderDTO.setExp(exp);
//            try {
//                mallOrderDTO.setKdn(this.getOrderExpInfo(exp));
//            } catch (Exception e) {
//                throw new BizException("获取物流失败");
//            }
        }
        //5合同信息
//        UavContractInfoDTO uavContractInfoDTO = fddServletClient.feignGetUAVContractByOId(orderId);
        UavContractInfoDTO uavContractInfoDTO = null;
        if(uavContractInfoDTO != null){
            mallOrderDTO.setContractNo(uavContractInfoDTO.getContractNo());
            mallOrderDTO.setSignStatus(uavContractInfoDTO.getSignStatus());
            mallOrderDTO.setArchiveDate(uavContractInfoDTO.getArchiveDate());
            // 保证合同状态同步一致
            if(!Objects.equals(mallOrderInfo.getSignStatus(),uavContractInfoDTO.getSignStatus())){
                MallOrderDO mallOrderDO = new MallOrderDO();
                mallOrderDO.setId(orderId);
                mallOrderDO.setSignStatus(uavContractInfoDTO.getSignStatus());
                mallOrderDao.updateMallOrder(mallOrderDO);
            }
        }
        //6订单标题
        List<Integer> orderIds = new ArrayList<>();
        orderIds.add(orderId);
        List<MallOrderSimpleDO> pMallOrderSimpleDOList = orderGoodsProdService.listOrderGoodsProdBaseInfo(orderIds);
//        List<MallOrderSimpleDO> iMallOrderSimpleDOList = orderGoodsIndstService.listOrderGoodsIndstBaseInfo(orderIds);
        List<MallOrderSimpleDO> iMallOrderSimpleDOList = null;
        //7初始化订单包含商品的数量
        int goodsNum = 0;
        if (!CollectionUtils.isEmpty(pMallOrderSimpleDOList)){
            mallOrderDTO.setOrderName(pMallOrderSimpleDOList.get(0).getOrderGoodsCommonDOS().get(0).getGoodsName());
            goodsNum += pMallOrderSimpleDOList.size();
        }
        if (!CollectionUtils.isEmpty(iMallOrderSimpleDOList)){
            mallOrderDTO.setOrderName(iMallOrderSimpleDOList.get(0).getOrderGoodsCommonDOS().get(0).getGoodsName());
            goodsNum += iMallOrderSimpleDOList.size();
        }
        mallOrderDTO.setGoodsNum(goodsNum);
        //8订单服务
        List<OrderServiceDO> orderServiceDOS = mallOrderDao.listOrderService(orderId);
        List<String> serviceName = orderServiceDOS.stream().map(OrderServiceDO::getServiceName).collect(Collectors.toList())
                .stream().distinct().collect(Collectors.toList());
        mallOrderDTO.setServiceNames(serviceName);
        //9订单付款状态转换
//        if (mallOrderDTO.getStatusCode().toString().equals(OrderStatus.ERROR_PAY.getCode().toString())) {
//            // 首次不通过
//            OrderPayDTO orderPay = mallOrderDao.getOrderPayInfo(orderId, null).buildOrderPayDTO();
//            mallOrderDTO.setPayErrInfo(orderPay.getRefuseReason());
//        } else if (mallOrderDTO.getStatusCode().toString().equals(OrderStatus.REFUSE_AFTER_PAY.getCode().toString())) {
//            // 尾款不通过
//            OrderPayDTO orderPay = mallOrderDao.getOrderPayInfo(orderId, PayType.AF_PAY.getCode()).buildOrderPayDTO();
//            mallOrderDTO.setPayErrInfo(orderPay.getRefuseReason());
//        }
        //10渠道信息
//        MallUserDTO mallUserDTO = mallUserClient.feignGetSimpleUserInfo(mallOrderInfo.getMallUserId());
        UserAccountSimpleDTO userAccountSimpleDTO = userClient.feignGetUserSimpleInfo(currentAccount.getUserAccountId(), token);
        if(userAccountSimpleDTO != null){
            mallOrderDTO.setUserName(userAccountSimpleDTO.getUserName());
            mallOrderDTO.setNickName(userAccountSimpleDTO.getNickName());
            mallOrderDTO.setCompanyName(userAccountSimpleDTO.getCompanyName());
            if (userAccountSimpleDTO.getCooperationTagId() != null && userAccountSimpleDTO.getCooperationTagId() != 0) {
                mallOrderDTO.setTagName(userAccountSimpleDTO.getTagName());
                mallOrderDTO.setCooperationTagId(userAccountSimpleDTO.getCooperationTagId());
            }
        }
        //11设置订单设置的规格信息
        List<MallOrderSimpleDO> mallOrderSimpleDOList = appMallOrderDao.listMallOrderSkuSpec(orderIds);
        for (MallOrderSimpleDO mallOrderSimpleDO : mallOrderSimpleDOList) {
            if (!CollectionUtils.isEmpty(mallOrderSimpleDO.getOgSkuSpecDOList()) && mallOrderSimpleDO.getId().equals(mallOrderDTO.getId())) {
                List<OGSkuSpecDTO> ogSkuSpecDTOList = mallOrderSimpleDO.getOgSkuSpecDOList().stream().map(OGSkuSpecDO::buildOGSkuSpecDTO).collect(Collectors.toList());
                mallOrderDTO.setOgSkuSpecDTOList(ogSkuSpecDTOList);
                break;
            }
        }
        //12查询订单使用的优惠券
//        List<OrderCouponDO> orderCouponDOS = appMallOrderDao.listOrderCoupon(orderId);
//        List<OrderCouponDTO> couponDTOS = orderCouponDOS.stream().map(d -> d.buildOrderCouponDTO()).collect(Collectors.toList());
//        mallOrderDTO.setOrderCouponDTOS(couponDTOS);
        return mallOrderDTO;
    }

    @Override
    public ResultBody updateMallOrderRemark(Integer orderId, String remark) {
        if (remark.length() > 600){
            return ResultBody.error("备注长度大于600！");
        }
        mallOrderDao.updateMallOrderRemark(orderId, remark);
        return ResultBody.success();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResultBody confirmOrderNew(ConfirmOrderNewVO confirmOrderNewVO, BaseAccountDTO currentAccount) {
        MallOrderVO mallOrderVO = confirmOrderNewVO.getMallOrderVO();
        if (mallOrderVO == null || mallOrderVO.getId() == null) {
            throw new BizException("订单id不能为空");
        }
        Integer mallOrderId = mallOrderVO.getId();
        MallOrderDO order = mallOrderDao.getMallOrderInfo(mallOrderId);
        //金额检验先注释20230406
        //mallOrderVO = updateCheckAndFill(mallOrderVO,order);
        ResultBody result = this.orderEvolution(order, OrderStatus.CONFIRM_ORDER.getCode());
        if (!ResultBody.isSuccess(result)) {
            return result;
        }
        Integer creditPeriodDays = mallOrderVO.getCreditPeriodDays();
        // 默认3天
        creditPeriodDays = (creditPeriodDays == null) ? 3 : creditPeriodDays;
        mallOrderVO.setCreditPeriodDays(creditPeriodDays);
        // 线下合同确认订单时填入订单期限，线上的话合同签署完成后填入订单期限
        if(mallOrderVO.getContractSignedWay().equals(0)){
            Date creditPeriod = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(creditPeriod);
            calendar.add(Calendar.DATE,creditPeriodDays);
            creditPeriod = calendar.getTime();
            mallOrderVO.setCreditPeriod(creditPeriod);
        }
        //设置实付金额
        BigDecimal realityAmount = order.getOrderAmount().subtract(order.getCouponDiscountAmount()).subtract(mallOrderVO.getManualDiscountAmount());
        if (realityAmount.compareTo(BigDecimal.ZERO) < 0){
            throw new BizException("折扣金额过大！");
        }
        mallOrderVO.setRealityAmount(realityAmount);
        /** 先注释，使用真正的优惠券20230406
        // 用优惠券的话，需要冻结用户奖励金
        BigDecimal discountAmount = mallOrderVO.getDiscountAmount();
        if(discountAmount.compareTo(BigDecimal.ZERO)>0){
            // 获取订单名字
            String orderName = "";
            List<MallOrderSimpleDO> pMallOrderSimpleDOList = orderGoodsProdService.listOrderGoodsProdBaseInfo(Arrays.asList(mallOrderId));
            List<MallOrderSimpleDO> iMallOrderSimpleDOList = orderGoodsIndstService.listOrderGoodsIndstBaseInfo(Arrays.asList(mallOrderId));
            if (!CollectionUtils.isEmpty(pMallOrderSimpleDOList)){
                orderName = pMallOrderSimpleDOList.get(0).getOrderGoodsCommonDOS().get(0).getGoodsName();
            }
            if (!CollectionUtils.isEmpty(iMallOrderSimpleDOList)){
                orderName = iMallOrderSimpleDOList.get(0).getOrderGoodsCommonDOS().get(0).getGoodsName();
            }
            ResultBody resultBody = mallUserPayClient.rebateFreezeByUserId(order.getMallUserId(), discountAmount, currentAccount.getId(), order.getOrderNo(),orderName);
            if(resultBody==null || !(resultBody.getCode().equals(ResultEnum.SUCCESS.getResultCode()))){
                throw new BizException("用户奖励金余额不足,请修改后重试");
            }
        }
        */

        mallOrderDao.updateMallOrder(BeanCopyUtils.properties(mallOrderVO, new MallOrderDO()));
        //修改收货地址信息
        if(confirmOrderNewVO.getOrderExpressVO() != null){
            orderExpressService.updateOrderExpress(confirmOrderNewVO.getOrderExpressVO());
        }
        //发订单状态变更通知
        this.sendOrderStatusChangeMsg(mallOrderId);
        return ResultBody.success();
    }

    // 修改前的数据校验与填充
//    private MallOrderVO updateCheckAndFill(MallOrderVO mallOrderVO, MallOrderDO mallOrderDO) {
//        // 判断金额是否改大了
//        BigDecimal orderAmount = mallOrderVO.getOrderAmount()==null? BigDecimal.ZERO:mallOrderVO.getOrderAmount();
//        BigDecimal rawOrderAmount = mallOrderDO.getOrderAmount()==null? BigDecimal.ZERO:mallOrderDO.getOrderAmount();
//        if(orderAmount.compareTo(rawOrderAmount)>0){
//            throw new BizException("调整后的金额不能比原金额大");
//        }
//        // 判断减免金额是否>=0
//        BigDecimal deductAmount = rawOrderAmount.subtract(orderAmount);
//        mallOrderVO.setDeductAmount(deductAmount);
//        if(deductAmount.compareTo(BigDecimal.ZERO)<0){
//            throw new BizException("减免金额不能少于0");
//        }
//        // 判断优惠金额是否合理
//        BigDecimal discountAmount = mallOrderVO.getDiscountAmount()==null? BigDecimal.ZERO:mallOrderVO.getDiscountAmount();
//        mallOrderVO.setDiscountAmount(discountAmount);
//        if(discountAmount.compareTo(BigDecimal.ZERO)<0){
//            throw new BizException("优惠金额不能少于0");
//        }
//        UavPayWalletInfoDTO payWalletDTO = mallUserPayClient.getUserWalletInfoByUserId(mallOrderDO.getMallUserId());
//        BigDecimal rcdRebateAmt = payWalletDTO.getRcdRebateAmt()==null? BigDecimal.ZERO:payWalletDTO.getRcdRebateAmt();
//        if(discountAmount.compareTo(rcdRebateAmt)>0){
//            throw new BizException("优惠金额不能大于用户奖励金余额,当前用户奖励金余额:"+rcdRebateAmt);
//        }
//        // 优惠金额不能大于最大配置比例上限
//        List<OrderConfigDTO> oderConfigInfo = orderConfigService.getOderConfigInfo();
//        OrderConfigDTO orderConfigDTO = oderConfigInfo.get(0);
//        BigDecimal upAmount = rawOrderAmount.multiply(orderConfigDTO.getConfigValue()).setScale(2, BigDecimal.ROUND_HALF_UP);
//        if(discountAmount.compareTo(upAmount)>0){
//            throw new BizException("请重新设置优惠金额,当前订单的优惠金额最大值:"+upAmount);
//        }
//        if(discountAmount.compareTo(mallOrderDO.getOrderAmount())>0){
//            throw new BizException("优惠金额不能大于当前订单的金额，当前订单金额为"+mallOrderDO.getOrderAmount());
//        }
//        // 计算实付金额
//        BigDecimal realityAmount = orderAmount.subtract(discountAmount);
//        if(realityAmount.compareTo(BigDecimal.ZERO)<0){
//            throw new BizException("计算后的实付金额为"+realityAmount+",不能为负数");
//        }
//        mallOrderVO.setRealityAmount(realityAmount);
//        // 兼容过去版本的订单金额
//        mallOrderVO.setOrderAmount(realityAmount);
//        return mallOrderVO;
//    }

    @Override
    @Transactional
    public ResultBody sendOrderGoodsNew(MallOrderExpressVO param, BaseAccountDTO currentAccount) throws Exception {
        MallOrderDO order = mallOrderDao.getMallOrderInfo(param.getOrderId());
        ResultBody result = this.orderEvolution(order, OrderStatus.SEND_ORDER_GOODS.getCode());
        if (!ResultBody.isSuccess(result)) {
            return result;
        }
        orderExpressService.updateOrderExpress(param);
        String KDNResult = KdnExpressUtil.monitorPush("UAV", order.getId(), param.getSendExpCode(), param.getSendExpNo(), param.getTakePhone());
        if(!JSONObject.parseObject(KDNResult).getString("Success").equals("true")){
            throw new BizException("快递信息错误，请重新填写后发货！");
        }
        this.sendOrderStatusChangeMsg(order.getId());
        //发短信
        MallOrderDTO mallOrderDTO = order.buildMallOrderDTO();
        mallOrderDTO.setStatusCode(OrderStatus.SEND_ORDER_GOODS.getCode());
        //publicsher.sendInitMallOrder(mallOrderDTO);
        return ResultBody.success();
    }

    private List<MallOrderProdListDTO> getMallOrderProdListDTOList(Integer orderId){
        //订单商品清单
        List<OrderGoodsProdDetailDO> pMallOrderProdListDTOS = orderGoodsProdService.listPMallOrderProdList(orderId);
        //List<OrderGoodsIndstProdListDO> iMallOrderProdListDTOS = orderGoodsIndstService.listIMallOrderProdList(orderId);
        List<MallOrderProdListDTO> mallOrderProdListDTOList = new ArrayList<>();
        if( !CollectionUtils.isEmpty(pMallOrderProdListDTOS) ){
            List<MallOrderProdListDTO> pMallOrderProdListDTO = pMallOrderProdListDTOS.stream().map(d -> {
                return d.buildMallOrderProdListDTO();
            }).collect(Collectors.toList());
            mallOrderProdListDTOList.addAll(pMallOrderProdListDTO);
        }
//        if ( !CollectionUtils.isEmpty(iMallOrderProdListDTOS) ){
//            List<MallOrderProdListDTO> iMallOrderProdListDTO = iMallOrderProdListDTOS.stream().map(d -> {
//                return d.buildMallOrderProdListDTO();
//            }).collect(Collectors.toList());
//            mallOrderProdListDTOList.addAll(iMallOrderProdListDTO);
//        }
        return mallOrderProdListDTOList;
    }

//    private List<MallOrderDTO> buildMallOrderInfoVerOne(List<MallOrderDO> orders) {
//        List<Long> orderIds = orders.stream().map(MallOrderDO::getId).collect(Collectors.toList());
//        List<OrderGoodsVerOneDTO> orderGoods = new ArrayList<>();
//        for (MallOrderDO order : orders) {
//            // 先测试数据是否跑通再改批量查询
//            orderGoods = getProductInfo(order.getId());
//        }
//        Map<Long, List<OrderGoodsVerOneDTO>> mapGood = orderGoods.stream()
//                .collect(Collectors.groupingBy(OrderGoodsVerOneDTO::getOrderId));
//        //匹配运营人员信息
//        List<Integer> opIds = orders.stream().distinct().map(MallOrderDO::getOperationId).collect(Collectors.toList());
//        opIds.removeIf(Objects::isNull);
//        opIds = opIds.stream().distinct().collect(Collectors.toList());
//        List<UserAccountDTO> operateUser = userServletClient.feignListUserAccountById(UserAccountQO.builder().userIds(opIds).build());
//        Map<Integer, UserAccountDTO> mapOperate = CollectionUtils.isEmpty(operateUser) ? null
//                : operateUser.stream().collect(Collectors.toMap(UserAccountDTO::getId, user -> user, (k1, k2) -> k2));
//        for (MallOrderDO d : orders) {
//            if (mapOperate != null && mapOperate.containsKey(d.getOperationId())) {
//                d.setOperationName(mapOperate.get(d.getOperationId()).getUserName());
//            }
//        }
//        List<MallOrderDTO> data = orders.stream().map(d -> {
//            // 前端状态描述显示修改
//            if (d.getStatusCode().equals(OrderStatus.CONFIRM_ORDER.getCode())) {
//                if (d.getSignStatus() != null) {
//                    if (d.getSignStatus().equals(0) || d.getSignStatus().equals(1) || d.getSignStatus().equals(2) || d.getSignStatus().equals(3) || d.getSignStatus().equals(4)) {
//                        d.setStatusCode(d.getSignStatus());
//                    }
//                }
//            }
//            //MallUserDTO mallUserDTO = mallUserClient.feignGetSimpleUserInfo(d.getRecMallUserId());
//            UserAccountSimpleDTO userAccountSimpleDTO = userAppApi.feignGetUserSimpleInfo(d.getRecMallUserId(), null);
//            if (userAccountSimpleDTO != null) {
//                String UserName = userAccountSimpleDTO.getUid() + "" + (userAccountSimpleDTO.getUserName() == null ? "" : "(" + userAccountSimpleDTO.getUserName() + ")");
//                d.setRecMallUserName(UserName);
//            }
//            // 查询合同编号
//            ResultBody<List<UavContractInfoDTO>> resultBody = fddServletClient.selectList(new UavContractInfoQO() {{
//                setMallOrderId(d.getId());
//            }});
//            if (resultBody != null && !CollectionUtils.isEmpty(resultBody.getResult())) {
//                UavContractInfoDTO uavContractInfo = resultBody.getResult().get(0);
//                d.setContractNo((uavContractInfo != null) ? uavContractInfo.getContractNo() : "");
//                d.setSignStatus((uavContractInfo != null) ? uavContractInfo.getSignStatus() : null);
//            }
//            // 查询订单的收货信息
//            List<UserAddressDTO> result = mallUserClient.feignSelectList(new UserAddressQO() {{
//                setId(d.getUserAddressId());
//                setIsDeleteds(Arrays.asList(0, 1));
//            }}).getResult();
//            if (!CollectionUtils.isEmpty(result)) {
//                d.setUserAddress(result.get(0));
//            }
//            MallOrderDTO od = d.buildMallOrderDTO();
//            od.setOrderGoods(mapGood.get(d.getId()));
//            return od;
//        }).collect(Collectors.toList());
//        return data;
//    }

    @Override
    public void exportMultiSheet(HttpServletResponse response, List<Integer> orderIds) throws IOException {
        // 判断id数组的长度是否大于5000
        if (orderIds.size() == 0 || orderIds.size() > 5000) {
            throw new BizException("没有需要导出的数据或导出数据大于5000条!");
        }
        List<OrderExportDTO> orderExportList = listOrderBasicInfo(orderIds);
        //确定写出文件的位置
        InputStream inputStreamFromUrl = ExcelTool.getInputStreamFromUrl("https://share-fly.oss-cn-hangzhou.aliyuncs.com/morder/%E5%AF%BC%E5%87%BA%E8%AE%A2%E5%8D%95%E6%A8%A1%E6%9D%BF%E4%BF%AE%E6%94%B9.xlsx");
        inputStreamFromUrl = new BufferedInputStream(inputStreamFromUrl);
        // 获取订单下单账号的信息
        String[] orderCodes = orderExportList.stream().map(OrderExportDTO::getOrderCode).toArray(String[]::new);
        String fileName = "订单数据" + TDateUtil.getCurrentDate();
        fileName = URLEncoder.encode(fileName, "UTF8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xlsx");
        inputStreamFromUrl = ExcelTool.cloneSheet(inputStreamFromUrl, 0, orderCodes);
        //如果你的模板有list,且list不是最后一行，下面还有数据需要填充 就必须设置 forceNewRow=true 但是这个就会把所有数据放到内存 会很耗内存
        ExcelWriter excelWriter = EasyExcel.write(response.getOutputStream()).withTemplate(inputStreamFromUrl).build();
        //遍历sheet并填充

        for (int i = 0; i < orderExportList.size(); i++) {
            OrderExportDTO orderTemplate = orderExportList.get(i);
            WriteSheet writeSheet = EasyExcel.writerSheet(orderTemplate.getOrderCode()).build();
            excelWriter.fill(orderTemplate, writeSheet);
            excelWriter.fill(orderTemplate.getItemList(), writeSheet);
        }
        excelWriter.finish();//不要忘记执行这个方法,关闭流,执行后才能真正填充数据
        excelWriter.close();
    }

    private List<OrderExportDTO> listOrderBasicInfo(List<Integer> orderIds) {
        List<OrderExportDTO> orderExportList = new ArrayList<>();
        // 根据订单id获取信息
        List<MallOrderDO> mallOrderList = mallOrderDao.listMallOrder(orderIds);
        // 获取下单用户的认证企业信息
        List<Integer> userIds = mallOrderList.stream().map(MallOrderDO::getUserAccountId).collect(Collectors.toList());
        //List<MallUserDTO> mallUserDTO = mallUserClient.feignListMallUserDTO(userIds);
        List<UserAccountSimpleDTO> userAccount = userClient.feignListUserAccountByIds(userIds, null);
        for (MallOrderDO mallOrderDO : mallOrderList) {
            OrderExportDTO orderExportDTO = new OrderExportDTO();
            //订单清单，产品和行业的
            List<OrderItem> orderItemList = this.getOrderItemList(mallOrderDO.getId());
            orderExportDTO.setItemList(orderItemList);
            orderExportDTO.setBuyerAccount(mallOrderDO.getUserName());
            orderExportDTO.setSaleOwner(mallOrderDO.getSaleName());
            orderExportDTO.setOrderCode(mallOrderDO.getOrderNo());
            for (UserAccountSimpleDTO userDTO : userAccount) {
                if (userDTO.getId().equals(mallOrderDO.getUserAccountId())){
                    //orderExportDTO.setAuthCompany(userDTO.getEntName());
                    break;
                }
            }
            orderExportList.add(orderExportDTO);
        }
        return orderExportList;
    }

    @Override
    public void listOperationalDataExport(MallOrderQO param, HttpServletResponse response, BaseAccountDTO currentAccount, String token) throws IOException {
        //不是管理员。都只能看自己相关的订单
//        if (currentAccount.getAdmin() != 1) {
//            param.setOperationId(currentAccount.getId());
//        }
        List<Integer> statusCode = param.getStatusCode();
        // 状态码转换
        statusCodeConvert(param, statusCode);

        int count = mallOrderDao.countPagePmOrderVerOne(param);
        if (count == 0) {
            throw new BizException("没有需要导出的数据");
        }
        List<MallOrderDO> list = mallOrderDao.listExportOrderVerOne(param);
        List<MallOrderPageDTO> mallOrderPageDTOList = this.buildMallOrderPageDTO(list, token);
        List<OperationalDataExcel> collect = mallOrderPageDTOList.stream().map(d -> {
            OperationalDataExcel operationalDataExcel = new OperationalDataExcel(d);
            List<MallGoodsInfoDTO> mallGoodsInfoDTOS = this.buildMallGoodsInfoDTO(d.getId());
            operationalDataExcel.setProductInventory(mallGoodsInfoDTOS);
            return operationalDataExcel;
        }).collect(Collectors.toList());
        Collection<OperationalDataExcel> coll = collect;
        Workbook workbook = ExcelExportUtil.exportExcel(new ExportParams("无人机城订单情况统计", "订单数据"), OperationalDataExcel.class, coll);
        String fileName = "订单数据" + TDateUtil.getCurrentDate();
        fileName = URLEncoder.encode(fileName, "UTF8");
        response.setContentType("application/vnd.ms-excel;chartset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xls");
        ServletOutputStream out = response.getOutputStream();
        workbook.write(out);
        out.flush();
        out.close();
    }

    @Override
    public void operationalDataExport(List<Integer> orderIds, HttpServletResponse response, BaseAccountDTO currentAccount) throws IOException {
//        // ①获取订单的基本信息
//        int count = mallOrderDao.countPageOrderInfo(orderIds);
//        if (count == 0) {
//            throw new BizException("没有需要导出的数据");
//        }
//        // 获取指定订单信息
//        List<MallOrderDO> list = mallOrderDao.listOperationalExportOrder(orderIds);
//        // 构建订单的基本信息
//        List<OrderBaseDTO> orderBaseList = this.buildOrderBaseInfo(list);
//        Workbook workbook = ExcelExportUtil.exportExcel(new ExportParams("无人机城订单情况统计", "订单数据"),
//                OperationalDataExcel.class,
//                orderBaseList.stream()
//                        .sorted(Comparator.comparing(OrderBaseDTO::getOrderDate, Comparator.reverseOrder()))
//                        .map(OperationalDataExcel::new).collect(Collectors.toList()));
//        String fileName = "订单数据" + TDateUtil.getCurrentDate();
//        fileName = URLEncoder.encode(fileName, "UTF8");
//        response.setContentType("application/vnd.ms-excel;chartset=utf-8");
//        response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xls");
//        ServletOutputStream out = response.getOutputStream();
//        workbook.write(out);
//        out.flush();
//        out.close();
    }

    /**
     * 构建订单基本信息
     *
     * @param list 列表
     * @return {@link List}<{@link OrderBaseDTO}>
     */
//    private List<OrderBaseDTO> buildOrderBaseInfo(List<MallOrderDO> list) {
//        List<OrderBaseDTO> orderBaseDTOList = new ArrayList<>();
//        // 获取用户信息
//        List<Integer> userIds = list.stream().map(MallOrderDO::getMallUserId).collect(Collectors.toList());
//        //List<MallUserDTO> mallUser = mallUserClient.feignListMallUserDTO(userIds);
//        List<UserAccountSimpleDTO> accountSimpleDTOS = userAppApi.feignListUserAccountByIds(userIds);
//        // 获取推荐人信息
//        //Map<Integer, MallUserDTO> integerMallUserDTOMap = mallUserPayClient.feignGetReferralInfos(userIds);
//        List<UserAccountSimpleDTO> referralInfos = userAppApi.feignListRcdUserInfo(userIds);
//        for (MallOrderDO d : list) {
//            OrderBaseDTO orderBaseDTO = new OrderBaseDTO()
//                    .setOrderNo(d.getOrderNo()).setOrderDate(d.getCreateTime())
//                    .setOrderAmount(d.getOrderAmount()).setActualPayment(d.getRealityAmount())
//                    .setDeductionAmount(d.getCouponDiscountAmount()).setDiscountAmount(d.getManualDiscountAmount())
//                    .setContractSignedWay(d.getContractSignedWay()).setMallUserId(d.getMallUserId()).setRemark(d.getRemark());
//            for (UserAccountSimpleDTO userDTO : accountSimpleDTOS) {
//                if (d.getMallUserId().equals(userDTO.getId())){
//                    // 获取用户渠道信息
//                    TagInfoDTO tagInfoDTO = systemServletClient.feignTagInfoById(mallUserDTO.getChannelClass());
//                    if (tagInfoDTO != null) {
//                        orderBaseDTO.setTagName(tagInfoDTO.getTagName());
//                    }
//                    // 组装下单用户信息
//                    orderBaseDTO.setUserNickname(userDTO.getUserName())
//                            .setUserNickname(userDTO.getNickName()).setEntName(userDTO.getEntName()).setRealNameAuth(userDTO.getEntVerifyStatus())
//                            .setMallUserId(userDTO.getId()).setUid(userDTO.getUid()).setTagName(userDTO.getTagName())
//                            .setSaleName(userDTO.getMallSaleManagerName())
//                            .setSaleUid(userDTO.getMallSaleManagerUID())
//                            .setOperationUid(userDTO.getMallOperatorUID())
//                            .setOperationName(userDTO.getMallOperatorName());
//                }
//            }
//            // 设置推荐人信息
//            if (integerMallUserDTOMap.size() > 0) {
//                MallUserDTO upReferralInfo = integerMallUserDTOMap.get(d.getMallUserId());
//                if (upReferralInfo != null) {
//                    orderBaseDTO.setRecMallUserName(upReferralInfo.getUserName());
//                    orderBaseDTO.setRecMallUid(upReferralInfo.getUid());
//                }
//            }
//            // 商品清单
//            List<MallGoodsInfoDTO> mallGoodsInfoDTOS = this.buildMallGoodsInfoDTO(d.getId());
//            orderBaseDTO.setMallGoodsInfoDTOS(mallGoodsInfoDTOS);
//            // 推荐人采购优惠价格
//            BigDecimal recDiscountTotalPrice = new BigDecimal(0);
//            for (MallGoodsInfoDTO mallGoodsInfoDTO : mallGoodsInfoDTOS) {
//                if (mallGoodsInfoDTO.getRecPrice()!=null) {
//                    recDiscountTotalPrice = recDiscountTotalPrice.add(mallGoodsInfoDTO.getRecPrice().multiply(new BigDecimal(mallGoodsInfoDTO.getCount())));
//                }
//            }
//            orderBaseDTO.setRecDiscountTotalPrice(recDiscountTotalPrice.compareTo(BigDecimal.ZERO)==0?null:recDiscountTotalPrice);
//            BigDecimal RecProfit = new BigDecimal(0);
//            if (d.getRealityAmount()!=null){
//                RecProfit = d.getRealityAmount().subtract(recDiscountTotalPrice);
//                if (RecProfit.compareTo(BigDecimal.ZERO) < 0 || RecProfit.compareTo(BigDecimal.ZERO) == 0) {
//                    orderBaseDTO.setRecProfit(new BigDecimal(0));
//                }else {
//                    orderBaseDTO.setRecProfit(RecProfit);
//                }
//            }
//            orderBaseDTOList.add(orderBaseDTO);
//        }
//        return orderBaseDTOList;
//    }

    /**
     * 金额需要计算下返回给前端
     * @param mallOrderDTO
     * @return
     */
//    @Override
    public MallOrderDTO moneyCalculate(MallOrderDTO mallOrderDTO) {
//        // 优惠金额计算;判断买家余额是否满足扣除“优惠金额”的默认设置值。
//        // 如果小于默认值，即显示买家余额值，如果大于默认值，即显示全局设置中定义的默认值。
//        List<OrderConfigDTO> oderConfigInfo = orderConfigService.getOderConfigInfo();
//        OrderConfigDTO defaultOrderConfig = oderConfigInfo.get(1);
//        BigDecimal orderAmount = mallOrderDTO.getOrderAmount()==null? BigDecimal.ZERO:mallOrderDTO.getOrderAmount();
//        BigDecimal discountAmount = orderAmount.multiply(defaultOrderConfig.getConfigValue()).setScale(2, BigDecimal.ROUND_HALF_UP);
//        UavPayWalletInfoDTO payWalletDTO = mallUserPayClient.getUserWalletInfoByUserId(mallOrderDTO.getMallUserId());
//        BigDecimal rcdRebateAmt = payWalletDTO.getRcdRebateAmt()==null? BigDecimal.ZERO:payWalletDTO.getRcdRebateAmt();
//        log.info("moneyCalculate日志payWalletDTO[{}],discountAmount[{}],rcdRebateAmt[{}]", JSONObject.toJSONString(payWalletDTO),discountAmount,rcdRebateAmt);
//        discountAmount = discountAmount.compareTo(rcdRebateAmt) < 0 ? discountAmount:rcdRebateAmt;
//        mallOrderDTO.setDiscountAmount(discountAmount);
//
//        // 实付金额计算,总金额减去优惠金额
//        mallOrderDTO.setRealityAmount(orderAmount.subtract(discountAmount));
        return mallOrderDTO;
    }

    @Override
    public ResultBody feignOrderUseCoupon(List<Integer> orderIds) {
        //待付款订单
        Integer obligation = mallOrderDao.countOrderForCouponUse(orderIds, OrderStatus.CONFIRM_ORDER.getCode());
        //已经付款订单
        Integer accountPaid = mallOrderDao.countOrderForCouponUse(orderIds, OrderStatus.CONFIRM_INVENTORY.getCode());
        Map<String, Integer> map = new HashMap<>();
        map.put("obligation", obligation);
        map.put("accountPaid", accountPaid);
        return ResultBody.success(map);
    }

    private List<OrderItem> getOrderItemList(Integer orderId){
        //订单商品清单
        List<OrderGoodsProdDetailDO> pMallOrderProdListDTOS = orderGoodsProdService.listPMallOrderProdList(orderId);
        List<OrderGoodsIndstProdListDO> iMallOrderProdListDTOS = orderGoodsIndstService.listIMallOrderProdList(orderId);
        List<OrderItem> mallOrderItemList = new ArrayList<>();
        if( !CollectionUtils.isEmpty(pMallOrderProdListDTOS) ){
            List<OrderItem> pMallOrderProdListDTO = pMallOrderProdListDTOS.stream().map(OrderGoodsProdDetailDO::buildMallOrderItemLis).collect(Collectors.toList());
            mallOrderItemList.addAll(pMallOrderProdListDTO);
        }
        if ( !CollectionUtils.isEmpty(iMallOrderProdListDTOS) ){
            List<OrderItem> iMallOrderProdListDTO = iMallOrderProdListDTOS.stream().map(OrderGoodsIndstProdListDO::buildMallOrderItemLis).collect(Collectors.toList());
            mallOrderItemList.addAll(iMallOrderProdListDTO);
        }
        return mallOrderItemList;
    }

    private List<MallGoodsInfoDTO> buildMallGoodsInfoDTO(Integer orderId){
        // 根据订单id获取下单用户信息
        MallOrderDO mallOrderInfo = mallOrderDao.getMallOrderInfo(orderId);
        // 推荐人id
        //Integer rcdId = mallUserPayClient.feignGetSuperiorRef(mallOrderInfo.getMallUserId());
        Integer rcdId = userClient.feignGetSuperiorRef(mallOrderInfo.getUserAccountId(), null);
        // 根据推荐人id获取推荐人的渠道信息
        //MallUserDTO mallUserDTO = mallUserClient.feignGetSimpleUserInfo(rcdId);
        UserAccountSimpleDTO userAccountSimpleDTO = userClient.feignGetUserSimpleInfo(rcdId, null);
        //订单商品清单
        List<OrderGoodsProdDetailDO> pMallOrderProdListDTOS = orderGoodsProdService.listPMallOrderProdList(orderId);
        List<OrderGoodsIndstProdListDO> iMallOrderProdListDTOS = orderGoodsIndstService.listIMallOrderProdList(orderId);
        List<MallGoodsInfoDTO> mallOrderItemList = new ArrayList<>();
        if( !CollectionUtils.isEmpty(pMallOrderProdListDTOS) ){
            List<MallGoodsInfoDTO> pMallOrderProdListDTO = pMallOrderProdListDTOS.stream().map(d->{
                MallGoodsInfoDTO mallGoodsInfoDTO = d.buildMallGoodsInfoDTO();
                if(userAccountSimpleDTO.getCooperationTagId() != null){
                    // 查询该渠道下的商品单价
                    ProductSpecPriceDTO productSpecPriceDTO = pmsClient.feignGetUnitPriceByTag(d.getProductSpecId(), userAccountSimpleDTO.getCooperationTagId(), null);
                    if (productSpecPriceDTO == null) {
                        mallGoodsInfoDTO.setRecPrice(d.getUnitPrice());
                    } else {
                        mallGoodsInfoDTO.setRecPrice(productSpecPriceDTO.getPrice());
                    }
                }
                return mallGoodsInfoDTO;
            }).collect(Collectors.toList());
            mallOrderItemList.addAll(pMallOrderProdListDTO);
        }
        if ( !CollectionUtils.isEmpty(iMallOrderProdListDTOS) ){
            List<MallGoodsInfoDTO> iMallOrderProdListDTO = iMallOrderProdListDTOS.stream().map(d -> {
                MallGoodsInfoDTO mallGoodsInfoDTO = d.buildMallGoodsInfoDTO();
                if (userAccountSimpleDTO.getCooperationTagId() != null) {
                    // 查询该渠道下的商品单价
                    ProductSpecPriceDTO productSpecPriceDTO = pmsClient.feignGetUnitPriceByTag(d.getProductSpecId(), userAccountSimpleDTO.getCooperationTagId(), null);
                    if (productSpecPriceDTO == null) {
                        mallGoodsInfoDTO.setRecPrice(d.getUnitPrice());
                    } else {
                        mallGoodsInfoDTO.setRecPrice(productSpecPriceDTO.getPrice());
                    }
                }
                return mallGoodsInfoDTO;
            }).collect(Collectors.toList());
            mallOrderItemList.addAll(iMallOrderProdListDTO);
        }
        return mallOrderItemList;
    }

    @Override
    public ResultBody getOrderInfoByOrderNo(String orderNo) {
        MallOrderDO mallOrderDO = mallOrderDao.getOrderInfoByOrderNo(orderNo);
        if (mallOrderDO == null) {
            return ResultBody.error(ResultEnum.ORDER_NO_EXIT_ERROR);
        }
        return ResultBody.success(mallOrderDO.buildMallOrderDTO());
    }
}

