package com.mmc.oms.controller.mall;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.BaseController;
import com.mmc.oms.entity.mall.PointsMallDO;
import com.mmc.oms.entity.mall.PointsOrderDO;
import com.mmc.oms.model.dto.mall.MallOrderPageDTO;
import com.mmc.oms.model.dto.user.BaseAccountDTO;
import com.mmc.oms.model.qo.GeneralQO;
import com.mmc.oms.model.qo.PointsMallOrderQO;
import com.mmc.oms.model.qo.mall.MallOrderQO;
import com.mmc.oms.service.mall.MallOrderService;
import com.mmc.oms.service.mall.PointMallService;
import io.swagger.annotations.*;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author Admin
 */
@Api(tags = { "积分商城(订单)" })
@RestController
@RequestMapping("/pointsMall/")
@AllArgsConstructor
public class PointsMallController extends BaseController {

    private final PointMallService pointMallService;

    @ApiOperation(value = "后台——添加积分商品")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("insertMall")
    public ResultBody insertMall(@RequestBody PointsMallDO param, HttpServletRequest request) {
        return pointMallService.insertMall(param);
    }
    @ApiOperation(value = "后台——删除积分商品")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("deleteMall")
    public ResultBody deleteMall(@RequestParam("id") Integer id) {
        return pointMallService.deleteMall(id);
    }
    @ApiOperation(value = "后台——修改积分商品")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("updateMall")
    public ResultBody updateMall(@RequestBody PointsMallDO param, HttpServletRequest request) {
        return pointMallService.updateMall(param);
    }

    @ApiOperation(value = "积分商品详情")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("getMallInfo")
    public ResultBody getMallInfo(@RequestParam("id") Integer id, HttpServletRequest request) {
        return pointMallService.getMallInfo(id);
    }
    @ApiOperation(value = "积分商城列表")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("getMallList")
    public ResultBody getMallList(@RequestBody GeneralQO qo, HttpServletRequest request) {
        return pointMallService.getMallList(qo);
    }



    @ApiOperation(value = "小程序——购买积分商品")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("buyGoods")
    public ResultBody buyGoods(@RequestBody PointsOrderDO pointsOrderDO, HttpServletRequest request) {
        Integer userAccountId = this.getCurrentAccount(request).getUserAccountId();
        pointsOrderDO.setUserId(userAccountId);
        return pointMallService.insertPointsOrder(pointsOrderDO,request);
    }

    @ApiOperation(value = "积分商品订单列表")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("mallOrderList")
    public ResultBody mallOrderList(@RequestBody PointsMallOrderQO qo, HttpServletRequest request) {
        Integer userAccountId = this.getCurrentAccount(request).getUserAccountId();
        if(qo.getIsAdmin() == 0){
            qo.setUserId(userAccountId);
        }
        return pointMallService.getOrderList(qo);
    }
    @ApiOperation(value = "修改商品订单")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("updateGoodsOrder")
    public ResultBody updateGoodsOrder(@RequestBody PointsOrderDO param) {
        return pointMallService.updateGoodsOrder(param);
    }




}
